/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.event.FlowEventCallback;
import com.solacesystems.solclientj.core.event.MessageCallback;
import com.solacesystems.solclientj.core.handle.FlowHandle;
import com.solacesystems.solclientj.core.handle.MessageHandle;
import com.solacesystems.solclientj.core.handle.SessionHandle;
import com.solacesystems.solclientj.core.handle.TransactedSessionHandle;
import com.solacesystems.solclientj.core.impl.AbstractMessageSupportBaseHandleImpl;
import com.solacesystems.solclientj.core.impl.ConceptConvertUtil;
import com.solacesystems.solclientj.core.impl.FlowHandleImpl;
import com.solacesystems.solclientj.core.impl.MessageHandleImpl;
import com.solacesystems.solclientj.core.impl.ccsmp.CCSMPServices;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.GenericPool;
import com.solacesystems.solclientj.core.impl.util.PoolUtil;
import com.solacesystems.solclientj.core.resource.Endpoint;
import com.solacesystems.solclientj.core.resource.Subscription;

public final class TransactedSessionHandleImpl
extends AbstractMessageSupportBaseHandleImpl
implements TransactedSessionHandle {
    private static final CCSMPServices ccsmp_services = CCSMPServices.onlyInstance();
    private SessionHandle sessionHandle;

    public TransactedSessionHandleImpl() {
    }

    public TransactedSessionHandleImpl(long value) {
        super(value);
    }

    protected void registerSessionHandle(SessionHandle sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    @Override
    public void destroy() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNITransactedSession().solClient_transactedSession_destroy(this.getPointerValue()), "solClient_transactedSession_destroy");
        this.setPointerValue(0L);
        this.sessionHandle = null;
        this.unregisterMessageCallback();
    }

    @Override
    public int commit() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNITransactedSession().solClient_transactedSession_commit(this.getPointerValue()), "solClient_transactedSession_commit");
    }

    @Override
    public int rollback() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNITransactedSession().solClient_transactedSession_rollback(this.getPointerValue()), "solClient_transactedSession_rollback");
    }

    @Override
    public int createFlowForHandle(FlowHandle in_out_flowHandle, String[] flowProperties, Endpoint endpoint, Subscription subscription, MessageCallback messageCallback, FlowEventCallback flowEventCallback) throws SolclientException {
        String[] jniFlowProperties = ConceptConvertUtil.validateForFlowCreate(in_out_flowHandle, flowProperties, endpoint, subscription, messageCallback, flowEventCallback, true);
        ((FlowHandleImpl)in_out_flowHandle).registerEndpoint(endpoint);
        int rc = 0;
        try {
            rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNITransactedSession().solClient_transactedSession_createFlow(this.getPointerValue(), jniFlowProperties, in_out_flowHandle), "solClient_transactedSession_createFlow");
            ((FlowHandleImpl)in_out_flowHandle).registerSessionHandle(this.sessionHandle);
            ((FlowHandleImpl)in_out_flowHandle).registerTransactedSessionHandle(this);
        }
        catch (SolclientException se) {
            ((FlowHandleImpl)in_out_flowHandle).registerEndpoint(null);
            throw se;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionName() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNITransactedSession().solClient_transactedSession_getSessionName(this.getPointerValue(), sb), "solClient_transactedSession_getSessionName");
            String string = sb.toString();
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public int send(MessageHandle msg) throws SolclientException {
        MessageHandleImpl in_msgHandleImpl = (MessageHandleImpl)msg;
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNITransactedSession().solClient_transactedSession_sendMsg(this.getPointerValue(), in_msgHandleImpl.getPointerValue()), "solClient_transactedSession_sendMsg");
    }

    @Override
    public SessionHandle getSession() throws SolclientException {
        return this.sessionHandle;
    }
}

