/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.event.FlowEvent;
import com.solacesystems.solclientj.core.event.FlowEventCallback;
import com.solacesystems.solclientj.core.event.MessageCallback;
import com.solacesystems.solclientj.core.handle.FlowHandle;
import com.solacesystems.solclientj.core.handle.MessageDispatchTargetHandle;
import com.solacesystems.solclientj.core.handle.MessageHandle;
import com.solacesystems.solclientj.core.handle.MutableMessageDispatchTargetHandle;
import com.solacesystems.solclientj.core.handle.SessionHandle;
import com.solacesystems.solclientj.core.handle.TransactedSessionHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractMessageSupportBaseHandleImpl;
import com.solacesystems.solclientj.core.impl.ConceptConvertUtil;
import com.solacesystems.solclientj.core.impl.DestinationStruct;
import com.solacesystems.solclientj.core.impl.EndpointImpl;
import com.solacesystems.solclientj.core.impl.FlowEventImpl;
import com.solacesystems.solclientj.core.impl.MessageDispatchTargetHandleImpl;
import com.solacesystems.solclientj.core.impl.MessageHandleImpl;
import com.solacesystems.solclientj.core.impl.MutableMessageDispatchTargetHandleImpl;
import com.solacesystems.solclientj.core.impl.ccsmp.CCSMPServices;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.GenericPool;
import com.solacesystems.solclientj.core.impl.util.PoolUtil;
import com.solacesystems.solclientj.core.resource.Destination;
import com.solacesystems.solclientj.core.resource.Endpoint;
import com.solacesystems.solclientj.core.resource.MutableTopic;
import com.solacesystems.solclientj.core.resource.Subscription;
import java.nio.ByteBuffer;

public final class FlowHandleImpl
extends AbstractMessageSupportBaseHandleImpl
implements FlowHandle {
    private static final CCSMPServices ccsmp_services = CCSMPServices.onlyInstance();
    private FlowEventCallback flowEventCallback = null;
    private FlowEventImpl lastFlowEvent = null;
    private SessionHandle sessionHandle = null;
    private Endpoint endpoint = null;
    private TransactedSessionHandle transactedSessionHandle;

    public FlowHandleImpl() {
    }

    public FlowHandleImpl(long value) {
        super(value);
    }

    protected void registerEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected void registerSessionHandle(SessionHandle sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    protected void registerTransactedSessionHandle(TransactedSessionHandle transactedSessionHandle) {
        this.transactedSessionHandle = transactedSessionHandle;
    }

    protected void registerFlowEventCallback(FlowEventCallback flowEventCallback) {
        this.flowEventCallback = flowEventCallback;
    }

    @Override
    public int subscribe(MessageDispatchTargetHandle in_msgDispatchTargetHandle, int flags, long correlationKey) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle("subscribe", in_msgDispatchTargetHandle, "Common.NullMessageDispatchTargetHandle");
        MessageDispatchTargetHandleImpl mdthImpl = (MessageDispatchTargetHandleImpl)in_msgDispatchTargetHandle;
        if (mdthImpl.isLocalDispatchOnly()) {
            flags |= 8;
        }
        Subscription subscription = mdthImpl.getSubscription();
        String topicSubscription = this.getTopicName(subscription);
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_topicSubscribeWithDispatch(this.getPointerValue(), flags, topicSubscription, mdthImpl, correlationKey), "solClient_flow_topicSubscribeWithDispatch_int");
        mdthImpl.registerMessageDispatcher(this);
        return rc;
    }

    @Override
    public int unsubscribe(MessageDispatchTargetHandle in_msgDispatchTargetHandle, int flags, long correlationKey) throws SolclientException {
        ExceptionGuard.assertUsableBoundHandle("unsubscribe", in_msgDispatchTargetHandle, "Common.NullMessageDispatchTargetHandle");
        MessageDispatchTargetHandleImpl mdthImpl = (MessageDispatchTargetHandleImpl)in_msgDispatchTargetHandle;
        if (mdthImpl.isLocalDispatchOnly()) {
            flags |= 8;
        }
        Subscription subscription = in_msgDispatchTargetHandle.getSubscription();
        String topicSubscription = this.getTopicName(subscription);
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_topicUnsubscribeWithDispatch(this.getPointerValue(), flags, topicSubscription, mdthImpl, correlationKey), "solClient_flow_topicUnsubscribeWithDispatch_int");
        mdthImpl.registerMessageDispatcher(null);
        return rc;
    }

    @Override
    public int subscribe(MutableMessageDispatchTargetHandle in_mutableMessageDispatchTargetHandle, MutableTopic subscription, MessageCallback messagecallback, boolean isLocalDispatchOnly, int flags, long correlationKey) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle("subscribe", in_mutableMessageDispatchTargetHandle, "Common.NullMutableMessageDispatchTargetHandle");
        MutableMessageDispatchTargetHandleImpl mmdthImpl = (MutableMessageDispatchTargetHandleImpl)in_mutableMessageDispatchTargetHandle;
        mmdthImpl.registerMutableTopic(subscription);
        mmdthImpl.setLocalDispatchOnly(isLocalDispatchOnly);
        mmdthImpl.registerMessageCallback(messagecallback);
        if (mmdthImpl.isLocalDispatchOnly()) {
            flags |= 8;
        }
        ByteBuffer mutableTopicSubscription = this.getTopicNameBuffer(subscription);
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_topicSubscribeWithDispatch(this.getPointerValue(), flags, mutableTopicSubscription, mmdthImpl, correlationKey), "solClient_flow_topicSubscribeWithDispatch_ByteBuffer");
        mmdthImpl.registerMessageDispatcher(this);
        return rc;
    }

    @Override
    public int unsubscribe(MutableMessageDispatchTargetHandle in_mutableMessageDispatchTargetHandle, int flags, long correlationKey) throws SolclientException {
        ExceptionGuard.assertUsableBoundHandle("unsubscribe", in_mutableMessageDispatchTargetHandle, "Common.NullMutableMessageDispatchTargetHandle");
        MutableMessageDispatchTargetHandleImpl mmdthImpl = (MutableMessageDispatchTargetHandleImpl)in_mutableMessageDispatchTargetHandle;
        if (mmdthImpl.isLocalDispatchOnly()) {
            flags |= 8;
        }
        ByteBuffer topicSubscription = this.getTopicNameBuffer(mmdthImpl.getMutableTopic());
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_topicUnsubscribeWithDispatch(this.getPointerValue(), flags, topicSubscription, mmdthImpl, correlationKey), "solClient_flow_topicUnsubscribeWithDispatch_ByteBuffer");
        mmdthImpl.registerMessageDispatcher(null);
        return rc;
    }

    @Override
    public int clearStats() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_clearStats(this.getPointerValue()), "solClient_flow_clearStats");
    }

    @Override
    public void getTxStats(long[] in_out_TxStats) throws SolclientException {
        throw new RuntimeException("getTxStats is not supported on a FlowHandle");
    }

    @Override
    public void getRxStats(long[] in_out_rxStats) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_getRxStats(this.getPointerValue(), in_out_rxStats), "solClient_flow_getRxStats");
    }

    @Override
    public int ack(long adMsgId) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_sendAck(this.getPointerValue(), adMsgId), "solClient_flow_sendAck");
    }

    @Override
    public int ack(MessageHandle messageHandle) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_sendAckForMessageHandle(this.getPointerValue(), ((MessageHandleImpl)messageHandle).getPointerValue()), "solClient_flow_sendAckForMessageHandle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getDestination() throws SolclientException {
        GenericPool.PoolEntry<DestinationStruct> pe = PoolUtil.destinationStructPool.borrowFromPool();
        DestinationStruct ds = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_getDestination(this.getPointerValue(), ds), "solClient_flow_getDestination");
            Destination destination = ConceptConvertUtil.getDestination(ds);
            return destination;
        }
        finally {
            PoolUtil.destinationStructPool.returnToPool(pe);
        }
    }

    @Override
    public int receive(MessageHandle in_out_MsgHandle, int timeout) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_receiveMsg(this.getPointerValue(), in_out_MsgHandle, timeout), "solClient_flow_receiveMsg");
    }

    @Override
    public TransactedSessionHandle getTransactedSession() throws SolclientException {
        return this.transactedSessionHandle;
    }

    @Override
    public SessionHandle getSession() throws SolclientException {
        return this.sessionHandle;
    }

    @Override
    public int stop() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_stop(this.getPointerValue()), "solClient_flow_stop");
    }

    @Override
    public int start() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_start(this.getPointerValue()), "solClient_flow_start");
    }

    @Override
    public int setMaxUnacked(int numOfMaxUnackedMsgs) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_setMaxUnacked(this.getPointerValue(), numOfMaxUnackedMsgs), "solClient_flow_setMaxUnacked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String flowPropertyName) throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_getProperty(this.getPointerValue(), flowPropertyName, sb), "solClient_flow_getProperty");
            String string = sb.toString();
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void destroy() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIFlow().solClient_flow_destroy(this.getPointerValue()), "solClient_flow_destroy");
        this.setPointerValue(0L);
        this.sessionHandle = null;
        this.transactedSessionHandle = null;
        this.flowEventCallback = null;
        this.unregisterMessageCallback();
        this.registerEndpoint(null);
    }

    @Override
    public void takeFlowEvent(FlowEvent flowEvent, boolean withInfoString) {
        if (flowEvent == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullFlowEvent"));
        }
        if (!(flowEvent instanceof FlowEventImpl)) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.InvalidFlowEventImpl"));
        }
        FlowEventImpl flowEventImpl = (FlowEventImpl)flowEvent;
        flowEventImpl.copy(this.lastFlowEvent, withInfoString);
    }

    @Override
    public FlowEvent getFlowEvent() {
        return this.lastFlowEvent;
    }

    public void onEvent(int responseCode, int flowEventEnum, long correlationKey) {
        if (flowEventEnum == 0) {
            if (this.endpoint != null) {
                if (!this.endpoint.isDurable()) {
                    ((EndpointImpl)this.endpoint).setName(this.getProperty("FLOW_BIND_NAME"));
                }
            } else {
                this.LOGGER.warning("FlowHandle.onEvent:" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpoint"));
            }
        }
        if (this.flowEventCallback == null) {
            this.LOGGER.warning("FlowHandle.onEvent:" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullFlowEventCallback"));
        }
        if (this.lastFlowEvent == null) {
            this.lastFlowEvent = new FlowEventImpl(responseCode, flowEventEnum);
        } else {
            this.lastFlowEvent.reset();
            this.lastFlowEvent.setResponseCode(responseCode);
            this.lastFlowEvent.setFlowEventEnum(flowEventEnum);
        }
        if (this.flowEventCallback != null) {
            this.flowEventCallback.onEvent(this);
        }
    }
}

