/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.event.Event;
import com.solacesystems.solclientj.core.impl.ccsmp.CCSMPServices;

public abstract class AbstractEventImpl
implements Event {
    private static final CCSMPServices ccsmp_services = CCSMPServices.onlyInstance();
    private String info;
    private int responseCode;
    private boolean fetchedInfo = false;

    public AbstractEventImpl() {
        this.fetchedInfo = false;
    }

    public AbstractEventImpl(int responseCode) {
        this.responseCode = responseCode;
        this.fetchedInfo = false;
    }

    public AbstractEventImpl(String info, int responseCode) {
        this.info = info;
        this.responseCode = responseCode;
        this.fetchedInfo = true;
    }

    protected void copy(Event event, boolean copyInfo) {
        if (copyInfo) {
            this.info = event.getInfo();
        }
        this.responseCode = event.getResponseCode();
        this.fetchedInfo = true;
    }

    @Override
    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    public String getInfo() {
        if (this.fetchedInfo) {
            return this.info;
        }
        this.info = ccsmp_services.getJNIContext().ccsmpJni_getLastEventInfo();
        this.fetchedInfo = true;
        return this.info;
    }

    protected void reset() {
        this.info = null;
        this.responseCode = 0;
        this.fetchedInfo = false;
    }

    protected void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResponseCode [");
        sb.append(this.responseCode);
        sb.append("] Info [");
        if (this.getInfo() != null) {
            sb.append(this.info);
        }
        sb.append("]");
        return sb.toString();
    }
}

