/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl.util;

import com.solacesystems.solclientj.core.impl.util.GenericPool;
import com.solacesystems.solclientj.core.impl.util.GenericPoolFactory;
import com.solacesystems.solclientj.core.impl.util.TLinkedList;

public class DefaultGenericPoolFactory<T>
implements GenericPoolFactory {
    protected Class<?> clazz;
    protected double defaultFillFactor = 0.2;
    protected double fillFactor;

    DefaultGenericPoolFactory(Class<?> clazz) {
        this.clazz = clazz;
        this.setFillFactor(this.defaultFillFactor);
    }

    @Override
    public int initial_fill(TLinkedList genericQueue, int maxSize) {
        int max = (int)((this.getFillFactor() > 1.0 ? 1.0 : this.getFillFactor()) * (double)maxSize);
        while (genericQueue.size() < max) {
            this.allocateOne(genericQueue);
        }
        return max;
    }

    @Override
    public void allocateOne(TLinkedList genericQueue) {
        try {
            if (this.clazz.isArray()) {
                throw new IllegalArgumentException("Sorry I do not support creating arrays");
            }
            Object item = this.clazz.newInstance();
            GenericPool.PoolEntry entry = new GenericPool.PoolEntry(item);
            genericQueue.add(entry);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to allocate a new object for pool", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to allocate a new object for pool", e);
        }
    }

    @Override
    public double getFillFactor() {
        return this.fillFactor;
    }

    @Override
    public void setFillFactor(double fillFactor) {
        this.fillFactor = fillFactor;
    }
}

