/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl.util;

import com.solacesystems.solclientj.core.SolEnum;
import com.solacesystems.solclientj.core.Solclient;
import com.solacesystems.solclientj.core.SolclientErrorInfo;
import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.handle.Handle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.Constants;
import com.solacesystems.solclientj.core.impl.util.SolEnumToStringUtil;
import com.solacesystems.solclientj.core.impl.util.SolLogger;

public class ExceptionGuard {
    private static SolLogger LOGGER = SolLogger.getLogger(Solclient.class.getName());

    public static void assertUsableBoundHandle(String operation, Handle handle, String RB_HANDLE_KEY) {
        if (handle == null) {
            throw new IllegalArgumentException(operation + ":" + SOLCLIENTJRB.BUNDLE.getStringSafely(RB_HANDLE_KEY));
        }
        if (!handle.isBound()) {
            throw new IllegalArgumentException(operation + ":" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.BoundHandle"));
        }
    }

    public static void assertUsableUnboundHandle(String operation, Handle handle, String RB_HANDLE_KEY) {
        if (handle == null) {
            throw new IllegalArgumentException(operation + ":" + SOLCLIENTJRB.BUNDLE.getStringSafely(RB_HANDLE_KEY));
        }
        if (handle.isBound()) {
            throw new IllegalArgumentException(operation + ":" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.UnboundHandle"));
        }
    }

    public static int assertReturnCode(int returnCode, String jniMethodName) throws SolclientException {
        return ExceptionGuard.assertReturnCode(returnCode, jniMethodName, Constants.getAcceptableReturnCodes(jniMethodName));
    }

    private static int assertReturnCode(int returnCode, String jniMethodName, int ... acceptableReturnCodes) throws SolclientException {
        boolean oneMatchedAcceptableReturnCode = false;
        for (int i = 0; i < acceptableReturnCodes.length; ++i) {
            if (acceptableReturnCodes[i] != returnCode) continue;
            oneMatchedAcceptableReturnCode = true;
            break;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(jniMethodName + ", rc: " + returnCode);
        }
        if (!oneMatchedAcceptableReturnCode) {
            if (returnCode != -1) {
                if (LOGGER.isWarningEnabled()) {
                    String returnCodeDesc = "UNKNOWN RETURN CODE";
                    if (SolEnumToStringUtil.getEnumFieldValues(SolEnum.ReturnCode.class).contains(returnCode)) {
                        returnCodeDesc = SolEnum.ReturnCode.toString(returnCode);
                    }
                    LOGGER.warning("VALIDATION: Unexpected Return Code [" + returnCode + ":" + returnCodeDesc + "] for method [" + jniMethodName + "]");
                }
                return returnCode;
            }
            SolclientErrorInfo solclientErrorInfo = Solclient.getLastErrorInfo();
            if (solclientErrorInfo != null && solclientErrorInfo.getErrorStr() != null) {
                if (!Solclient.isInitialized()) {
                    throw new SolclientException(SOLCLIENTJRB.BUNDLE.getStringSafely("Solclient.NotInitialized"), solclientErrorInfo, returnCode);
                }
                throw new SolclientException(solclientErrorInfo, returnCode);
            }
            throw new IllegalStateException(String.format(SOLCLIENTJRB.BUNDLE.getStringSafely("ExceptionGuard.UnknownCause"), returnCode, SolEnum.ReturnCode.toString(returnCode), jniMethodName));
        }
        return returnCode;
    }
}

