/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl.util;

import com.solacesystems.solclientj.core.SolEnum;
import com.solacesystems.solclientj.core.impl.ccsmp.JNIConstants;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SolEnumToStringUtil {
    private static final Map<Class<?>, Map<Object, String>> solEnumsFieldData = new HashMap();
    private static final Map<Class<?>, Collection<String>> solEnumsFieldNames = new HashMap();
    private static final Map<Class<?>, Collection<Object>> solEnumsFieldValues = new HashMap();
    private static final Map<Class<?>, Class<?>> solEnumsFieldTypes = new HashMap();
    private static final List<Class<?>> solEnumClasses = new ArrayList();
    private static boolean omitCodeValidation = false;

    public static void addClass(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        if (clazz.getPackage() == null) {
            return;
        }
        if (!clazz.getPackage().getName().contains("com.solacesystems.solclientj.core")) {
            return;
        }
        HashMap<Object, String> m = new HashMap<Object, String>();
        solEnumsFieldData.put(clazz, m);
        solEnumClasses.add(clazz);
        ArrayList<String> fieldNames = new ArrayList<String>();
        solEnumsFieldNames.put(clazz, fieldNames);
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        solEnumsFieldValues.put(clazz, fieldValues);
        int fieldCount = 0;
        for (Field f : clazz.getDeclaredFields()) {
            if (f.isSynthetic()) continue;
            ++fieldCount;
            try {
                Object value = f.get(null);
                if (!solEnumsFieldTypes.containsKey(clazz)) {
                    solEnumsFieldTypes.put(clazz, f.getType());
                } else if (!solEnumsFieldTypes.get(clazz).equals(f.getType()) && !omitCodeValidation) {
                    throw new RuntimeException("CODE VALIDATION: Please ensure SolEnum does not declare fields of different types I had [" + solEnumsFieldTypes.get(clazz).getName() + "] and now I see [" + f.getType().getName() + "]");
                }
                String previous = null;
                if (String.class.isAssignableFrom(f.getType()) && value instanceof String) {
                    previous = m.put(value, f.getName());
                    if (previous != null) {
                        if (f.getAnnotation(Deprecated.class) != null) {
                            m.put(value, previous);
                            --fieldCount;
                            continue;
                        }
                        if (!omitCodeValidation) {
                            throw new RuntimeException("CODE VALIDATION: Looks there is an alias in class [" + clazz.getName() + "] this field [" + f.getName() + "] is an alias for [" + previous + "] the fields share the same value [" + value + "] please remove one of them.");
                        }
                    }
                    fieldNames.add(f.getName());
                    fieldValues.add(value);
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(f.getType())) {
                    previous = m.put((Integer)value, f.getName());
                    if (previous != null) {
                        if (f.getAnnotation(Deprecated.class) != null) {
                            m.put(value, previous);
                            --fieldCount;
                            continue;
                        }
                        if (!omitCodeValidation) {
                            throw new RuntimeException("CODE VALIDATION: Looks there is an alias in class [" + clazz.getName() + "] this field [" + f.getName() + "] is an alias for [" + previous + "] the fields share the same value [" + value + "] please remove one of them.");
                        }
                    }
                    fieldNames.add(f.getName());
                    fieldValues.add((Integer)value);
                    continue;
                }
                if (omitCodeValidation) continue;
                throw new RuntimeException("CODE VALIDATION: Looks like there is a new type [" + f.getType().getName() + "] introduced to SolEnum, please handle that in [" + SolEnumToStringUtil.class.getName() + "]");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to add field " + f.getName() + " to class " + clazz.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to add field " + f.getName() + " to class " + clazz.getName(), e);
            }
        }
        if (!(m.size() == fieldCount && fieldNames.size() == fieldCount || omitCodeValidation)) {
            throw new RuntimeException("CODE VALIDATION: Please check the fields in clazz [" + clazz.getName() + "] are there any duplicated field values? or fields that have no business being there?");
        }
    }

    private static void init() {
        Class<?>[] classList = SolEnum.class.getClasses();
        if (classList != null) {
            for (int c = 0; c < classList.length; ++c) {
                Class<?> clazz = classList[c];
                SolEnumToStringUtil.addClass(clazz);
            }
        }
    }

    public static String toString(Class<?> clazz, Object fieldValue) {
        if (solEnumsFieldData.containsKey(clazz)) {
            if (solEnumsFieldData.get(clazz).containsKey(fieldValue)) {
                return solEnumsFieldData.get(clazz).get(fieldValue);
            }
            throw new IllegalArgumentException("Unsupported SolEnum lookup for class [" + clazz + "] and value [" + fieldValue + "]");
        }
        throw new IllegalArgumentException("Unsupported SolEnum lookup for class [" + clazz + "]");
    }

    public static final int getEnumCount(Class<?> clazz) {
        if (solEnumsFieldData.containsKey(clazz)) {
            return solEnumsFieldData.get(clazz).size();
        }
        throw new IllegalArgumentException("Unsupported SolEnum lookup for class [" + clazz + "]");
    }

    public static Collection<String> getEnumFieldNames(Class<?> clazz) {
        if (solEnumsFieldNames.containsKey(clazz)) {
            return solEnumsFieldNames.get(clazz);
        }
        throw new IllegalArgumentException("Unsupported SolEnum lookup for class [" + clazz + "]");
    }

    public static Collection<Object> getEnumFieldValues(Class<?> clazz) {
        if (solEnumsFieldValues.containsKey(clazz)) {
            return solEnumsFieldValues.get(clazz);
        }
        throw new IllegalArgumentException("Unsupported SolEnum lookup for class [" + clazz + "]");
    }

    public static Class<?> getSolEnumsFieldType(Class<?> clazz) {
        if (solEnumsFieldTypes.containsKey(clazz)) {
            return solEnumsFieldTypes.get(clazz);
        }
        throw new IllegalArgumentException("Unsupported SolEnum lookup for class [" + clazz + "]");
    }

    public static List<Class<?>> geSolEnumClasses() {
        return solEnumClasses;
    }

    static {
        if (System.getProperty("SOLACE_SOLCLIENTJ_TEST") != null) {
            omitCodeValidation = true;
        }
        SolEnumToStringUtil.init();
        SolEnumToStringUtil.addClass(JNIConstants.CapabilityType.class);
    }
}

