/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.fmt;

import com.spotify.fmt.Logging;
import com.spotify.fmt.SerializableCallable;
import com.spotify.fmt.Serialization;
import com.spotify.fmt.SerializationException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;

class ForkingExecutor
implements Closeable {
    private final Log log;
    private final List<Execution<?>> executions = new ArrayList();
    private Map<String, String> environment = Collections.emptyMap();
    private List<String> javaArgs = Collections.emptyList();
    private boolean withDefaultClasspath = true;
    private List<String> configuredClasspath = Collections.emptyList();

    public ForkingExecutor(Log log) {
        this.log = log;
    }

    ForkingExecutor environment(Map<String, String> environment) {
        this.environment = new HashMap<String, String>(environment);
        return this;
    }

    ForkingExecutor javaArgs(String ... javaArgs) {
        return this.javaArgs(Arrays.asList(javaArgs));
    }

    ForkingExecutor javaArgs(List<String> javaArgs) {
        this.javaArgs = new ArrayList<String>(javaArgs);
        return this;
    }

    ForkingExecutor classpath(Collection<String> classpath) {
        this.configuredClasspath = new ArrayList<String>(classpath);
        return this;
    }

    ForkingExecutor withDefaultClasspath(boolean withDefaultClasspath) {
        this.withDefaultClasspath = withDefaultClasspath;
        return this;
    }

    private List<String> defaultClasspath() {
        return Arrays.asList(System.getProperty("java.class.path").split(File.pathSeparator));
    }

    private List<String> executionClassPath() {
        return this.withDefaultClasspath ? Stream.concat(this.configuredClasspath.stream(), this.defaultClasspath().stream()).collect(Collectors.toList()) : this.configuredClasspath;
    }

    <T> T execute(SerializableCallable<T> f) throws IOException {
        try (Execution<T> execution = new Execution<T>(this.executionClassPath(), f);){
            this.executions.add(execution);
            execution.start();
            T t = execution.waitFor();
            return t;
        }
    }

    @Override
    public void close() {
        this.executions.forEach(Execution::close);
    }

    private void tryDeleteDir(Path path) {
        try {
            ForkingExecutor.deleteDir(path);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Failed to delete directory: " + path), (Throwable)e);
        }
    }

    private static void deleteDir(Path path) throws IOException {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    try {
                        Files.delete(dir);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private void copyLines(InputStream in, PrintStream out) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                out.println(line);
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Caught exception during stream copy", (Throwable)e);
        }
    }

    private class Execution<T>
    implements Closeable {
        private final ExecutorService executor = Executors.newCachedThreadPool();
        private final Path tempdir = Files.createTempDirectory("fmt-maven-plugin", new FileAttribute[0]);
        private final Path workdir = Files.createDirectory(this.tempdir.resolve("workdir"), new FileAttribute[0]);
        private final Path closureFile = this.tempdir.resolve("closure");
        private final Path resultFile = this.tempdir.resolve("result");
        private final Path errorFile = this.tempdir.resolve("error");
        private final String home = System.getProperty("java.home");
        private final Path java = Paths.get(this.home, "bin", "java").toAbsolutePath().normalize();
        private final List<String> classpath;
        private final SerializableCallable<T> f;
        private Process process;

        Execution(List<String> classpath, SerializableCallable<T> f) throws IOException {
            this.classpath = classpath;
            this.f = Objects.requireNonNull(f);
        }

        void start() {
            if (this.process != null) {
                throw new IllegalStateException();
            }
            ForkingExecutor.this.log.debug((CharSequence)"serializing closure");
            try {
                Serialization.serialize(this.f, this.closureFile);
            }
            catch (SerializationException e) {
                throw new RuntimeException("Failed to serialize closure", e);
            }
            String classPathArg = String.join((CharSequence)File.pathSeparator, this.classpath);
            ProcessBuilder processBuilder = new ProcessBuilder(this.java.toString(), "-cp", classPathArg).directory(this.workdir.toFile());
            ForkingExecutor.this.javaArgs.forEach(processBuilder.command()::add);
            processBuilder.command().add(Trampoline.class.getName());
            processBuilder.command().add(this.closureFile.toString());
            processBuilder.command().add(this.resultFile.toString());
            processBuilder.command().add(this.errorFile.toString());
            processBuilder.environment().putAll(ForkingExecutor.this.environment);
            ForkingExecutor.this.log.debug((CharSequence)MessageFormat.format("Starting subprocess: environment={0}, command={1}, directory={2}", processBuilder.environment(), processBuilder.command(), processBuilder.directory()));
            try {
                this.process = processBuilder.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.executor.submit(() -> ForkingExecutor.this.copyLines(this.process.getInputStream(), System.out));
            this.executor.submit(() -> ForkingExecutor.this.copyLines(this.process.getErrorStream(), System.err));
        }

        T waitFor() {
            Object result;
            int exitValue;
            if (this.process == null) {
                throw new IllegalStateException();
            }
            ForkingExecutor.this.log.debug((CharSequence)"Waiting for subprocess exit");
            try {
                exitValue = this.process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            finally {
                this.process.destroyForcibly();
            }
            ForkingExecutor.this.log.debug((CharSequence)("Subprocess exited: " + exitValue));
            if (exitValue != 0) {
                throw new RuntimeException("Subprocess failed: " + this.process.exitValue());
            }
            if (Files.exists(this.errorFile, new LinkOption[0])) {
                Throwable error;
                ForkingExecutor.this.log.debug((CharSequence)"Subprocess exited with error file");
                try {
                    error = (Throwable)Serialization.deserialize(this.errorFile);
                }
                catch (SerializationException e) {
                    throw new RuntimeException("Failed to deserialize error", e);
                }
                if (error instanceof Error) {
                    throw (Error)error;
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new RuntimeException(error);
            }
            ForkingExecutor.this.log.debug((CharSequence)"Subprocess exited with result file");
            try {
                result = Serialization.deserialize(this.resultFile);
            }
            catch (SerializationException e) {
                throw new RuntimeException("Failed to deserialize result", e);
            }
            return result;
        }

        @Override
        public void close() {
            if (this.process != null) {
                this.process.destroyForcibly();
                this.process = null;
            }
            this.executor.shutdown();
            ForkingExecutor.this.tryDeleteDir(this.tempdir);
        }
    }

    private static class Trampoline {
        private static Log log = Logging.getLog();

        private Trampoline() {
        }

        public static void main(String ... args) {
            Path errorFile;
            Path resultFile;
            Path closureFile;
            log.debug((CharSequence)("child process started: args=" + Arrays.asList(args)));
            Watchdog watchdog = new Watchdog();
            watchdog.start();
            if (args.length != 3) {
                log.error((CharSequence)"args.length != 3");
                System.exit(3);
                return;
            }
            try {
                closureFile = Paths.get(args[0], new String[0]);
                resultFile = Paths.get(args[1], new String[0]);
                errorFile = Paths.get(args[2], new String[0]);
            }
            catch (InvalidPathException e) {
                log.error((CharSequence)"Failed to get file path", (Throwable)e);
                System.exit(4);
                return;
            }
            Trampoline.run(closureFile, resultFile, errorFile);
        }

        private static void run(Path closureFile, Path resultFile, Path errorFile) {
            SerializableCallable fn;
            log.debug((CharSequence)("deserializing closure: " + closureFile));
            try {
                fn = (SerializableCallable)Serialization.deserialize(closureFile);
            }
            catch (SerializationException e) {
                log.error((CharSequence)("Failed to deserialize closure: " + closureFile), (Throwable)e);
                System.exit(5);
                return;
            }
            log.debug((CharSequence)"executing closure");
            Object result = null;
            Throwable error = null;
            try {
                result = fn.call();
            }
            catch (Throwable e) {
                error = e;
            }
            if (error != null) {
                log.debug((CharSequence)"serializing error", error);
                try {
                    Serialization.serialize((Object)error, errorFile);
                }
                catch (SerializationException e) {
                    log.error((CharSequence)"failed to serialize error", (Throwable)e);
                    System.exit(6);
                    return;
                }
            }
            log.debug((CharSequence)("serializing result: " + result));
            try {
                Serialization.serialize(result, resultFile);
            }
            catch (SerializationException e) {
                log.error((CharSequence)"failed to serialize result", (Throwable)e);
                System.exit(7);
                return;
            }
            System.err.flush();
            System.exit(0);
        }

        private static class Watchdog
        extends Thread {
            Watchdog() {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    int c;
                    while ((c = System.in.read()) != -1) {
                    }
                }
                catch (IOException e) {
                    log.error((CharSequence)"watchdog failed", (Throwable)e);
                }
                log.debug((CharSequence)"child process exiting");
                System.exit(-1);
            }
        }
    }
}

