/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.impl;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.annotation.NoClass;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public abstract class TypeDeserializerBase
extends TypeDeserializer
implements Serializable {
    private static final long serialVersionUID = 278445030337366675L;
    protected final TypeIdResolver _idResolver;
    protected final JavaType _baseType;
    protected final BeanProperty _property;
    protected final JavaType _defaultImpl;
    protected final String _typePropertyName;
    protected final boolean _typeIdVisible;
    protected final HashMap<String, JsonDeserializer<Object>> _deserializers;
    protected JsonDeserializer<Object> _defaultImplDeserializer;

    protected TypeDeserializerBase(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl, Class<?> clazz) {
        this._baseType = javaType;
        this._idResolver = typeIdResolver;
        this._typePropertyName = string;
        this._typeIdVisible = bl;
        this._deserializers = new HashMap();
        this._defaultImpl = clazz == null ? null : javaType.forcedNarrowBy(clazz);
        this._property = null;
    }

    protected TypeDeserializerBase(TypeDeserializerBase typeDeserializerBase, BeanProperty beanProperty) {
        this._baseType = typeDeserializerBase._baseType;
        this._idResolver = typeDeserializerBase._idResolver;
        this._typePropertyName = typeDeserializerBase._typePropertyName;
        this._typeIdVisible = typeDeserializerBase._typeIdVisible;
        this._deserializers = typeDeserializerBase._deserializers;
        this._defaultImpl = typeDeserializerBase._defaultImpl;
        this._defaultImplDeserializer = typeDeserializerBase._defaultImplDeserializer;
        this._property = beanProperty;
    }

    @Override
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    public String baseTypeName() {
        return this._baseType.getRawClass().getName();
    }

    @Override
    public final String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl == null ? null : this._defaultImpl.getRawClass();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.getClass().getName());
        stringBuilder.append("; base-type:").append(this._baseType);
        stringBuilder.append("; id-resolver: ").append(this._idResolver);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JsonDeserializer<Object> _findDeserializer(DeserializationContext deserializationContext, String string) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> jsonDeserializer;
        HashMap<String, JsonDeserializer<Object>> hashMap = this._deserializers;
        synchronized (hashMap) {
            jsonDeserializer = this._deserializers.get(string);
            if (jsonDeserializer == null) {
                JavaType javaType = this._idResolver.typeFromId(string);
                if (javaType == null) {
                    if (this._defaultImpl == null) {
                        throw deserializationContext.unknownTypeException(this._baseType, string);
                    }
                    jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
                } else {
                    if (this._baseType != null && this._baseType.getClass() == javaType.getClass()) {
                        javaType = this._baseType.narrowBy(javaType.getRawClass());
                    }
                    jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, this._property);
                }
                this._deserializers.put(string, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JsonDeserializer<Object> _findDefaultImplDeserializer(DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._defaultImpl == null) {
            if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
                return NullifyingDeserializer.instance;
            }
            return null;
        }
        if (this._defaultImpl.getRawClass() == NoClass.class) {
            return NullifyingDeserializer.instance;
        }
        JavaType javaType = this._defaultImpl;
        synchronized (javaType) {
            if (this._defaultImplDeserializer == null) {
                this._defaultImplDeserializer = deserializationContext.findContextualValueDeserializer(this._defaultImpl, this._property);
            }
            return this._defaultImplDeserializer;
        }
    }
}

