/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.spotify.docker.client.DockerDateFormat;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParser;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.spotify.docker.client.shaded.javax.ws.rs.Produces;
import com.spotify.docker.client.shaded.javax.ws.rs.ext.ContextResolver;
import com.spotify.docker.client.shaded.javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json"})
public class ObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    private static final Logger log = LoggerFactory.getLogger(ObjectMapperProvider.class);
    private static final Function<? super Object, ?> VOID_VALUE = new Function<Object, Object>(){

        public Object apply(Object input) {
            return null;
        }
    };
    private static final SimpleModule MODULE = new SimpleModule();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public ObjectMapper getContext(Class<?> type) {
        return OBJECT_MAPPER;
    }

    static ObjectMapper objectMapper() {
        return OBJECT_MAPPER;
    }

    static {
        try {
            MODULE.addSerializer(Set.class, new SetSerializer());
            MODULE.addDeserializer(Set.class, new SetDeserializer());
            MODULE.addSerializer(ImmutableSet.class, new ImmutableSetSerializer());
            MODULE.addDeserializer(ImmutableSet.class, new ImmutableSetDeserializer());
            OBJECT_MAPPER.registerModule(new GuavaModule());
            OBJECT_MAPPER.registerModule(MODULE);
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            OBJECT_MAPPER.setDateFormat(new DockerDateFormat());
        }
        catch (Throwable t) {
            log.error("Failure during static initialization", t);
            throw t;
        }
    }

    private static class ImmutableSetDeserializer
    extends JsonDeserializer<ImmutableSet> {
        private ImmutableSetDeserializer() {
        }

        @Override
        public ImmutableSet<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Map map = OBJECT_MAPPER.readValue(jp, Map.class);
            return map == null ? null : ImmutableSet.copyOf(map.keySet());
        }
    }

    private static class ImmutableSetSerializer
    extends JsonSerializer<ImmutableSet> {
        private ImmutableSetSerializer() {
        }

        @Override
        public void serialize(ImmutableSet value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Map map = value == null ? null : Maps.asMap((Set)value, (Function)VOID_VALUE);
            OBJECT_MAPPER.writeValue(jgen, (Object)map);
        }
    }

    private static class SetDeserializer
    extends JsonDeserializer<Set> {
        private SetDeserializer() {
        }

        @Override
        public Set<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Map map = OBJECT_MAPPER.readValue(jp, Map.class);
            return map == null ? null : map.keySet();
        }
    }

    private static class SetSerializer
    extends JsonSerializer<Set> {
        private SetSerializer() {
        }

        @Override
        public void serialize(Set value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Map map = value == null ? null : Maps.asMap((Set)value, (Function)VOID_VALUE);
            OBJECT_MAPPER.writeValue(jgen, (Object)map);
        }
    }
}

