/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.datatype.guava.ser;

import com.google.common.base.Optional;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.MapperFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;

public final class GuavaOptionalSerializer
extends StdSerializer<Optional<?>>
implements ContextualSerializer {
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected transient PropertySerializerMap _dynamicSerializers;

    public GuavaOptionalSerializer(JavaType optionalType) {
        super(optionalType);
        this._referredType = GuavaOptionalSerializer._valueType(optionalType);
        this._property = null;
        this._valueSerializer = null;
        this._unwrapper = null;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected GuavaOptionalSerializer(GuavaOptionalSerializer base, BeanProperty property, JsonSerializer<?> valueSer, NameTransformer unwrapper) {
        super(base);
        this._referredType = base._referredType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._property = property;
        this._valueSerializer = valueSer;
        this._unwrapper = unwrapper;
    }

    protected GuavaOptionalSerializer withResolved(BeanProperty prop, JsonSerializer<?> ser, NameTransformer unwrapper) {
        if (this._property == prop && this._valueSerializer == ser && this._unwrapper == unwrapper) {
            return this;
        }
        return new GuavaOptionalSerializer(this, prop, ser, unwrapper);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            boolean realType;
            boolean bl = realType = !this._referredType.hasRawClass(Object.class);
            if (realType && (provider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this._referredType.isFinal())) {
                return this.withResolved(property, provider.findPrimaryPropertySerializer(this._referredType, property), this._unwrapper);
            }
        } else {
            return this.withResolved(property, provider.handlePrimaryContextualization(ser, property), this._unwrapper);
        }
        return this;
    }

    @Override
    public JsonSerializer<Optional<?>> unwrappingSerializer(NameTransformer transformer) {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser != null) {
            ser = ser.unwrappingSerializer(transformer);
        }
        NameTransformer unwrapper = this._unwrapper == null ? transformer : NameTransformer.chainedTransformer(transformer, this._unwrapper);
        return this.withResolved(this._property, ser, unwrapper);
    }

    @Override
    @Deprecated
    public boolean isEmpty(Optional<?> value) {
        return this.isEmpty((SerializerProvider)null, value);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Optional<?> value) {
        return value == null || !value.isPresent();
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    @Override
    public void serialize(Optional<?> opt, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (opt.isPresent()) {
            Object value = opt.get();
            JsonSerializer<Object> ser = this._valueSerializer;
            if (ser == null) {
                ser = this._findSerializer(provider, value.getClass());
            }
            ser.serialize(value, gen, provider);
        } else {
            provider.defaultSerializeNull(gen);
        }
    }

    @Override
    public void serializeWithType(Optional<?> opt, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (opt.isPresent()) {
            Object value = opt.get();
            JsonSerializer<Object> ser = this._valueSerializer;
            if (ser == null) {
                ser = this._findSerializer(provider, value.getClass());
            }
            ser.serializeWithType(value, gen, provider, typeSer);
        } else {
            provider.defaultSerializeNull(gen);
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(visitor.getProvider(), this._referredType.getRawClass());
        }
        ser.acceptJsonFormatVisitor(visitor, this._referredType);
    }

    protected static JavaType _valueType(JavaType optionalType) {
        JavaType valueType = optionalType.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        return valueType;
    }

    protected final JsonSerializer<Object> _findSerializer(SerializerProvider provider, Class<?> type) throws JsonMappingException {
        JsonSerializer<Object> ser = this._dynamicSerializers.serializerFor(type);
        if (ser == null) {
            ser = provider.findPrimaryPropertySerializer(type, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicSerializers = this._dynamicSerializers.newWith(type, ser);
        }
        return ser;
    }
}

