/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.google.common.base.Preconditions;
import com.squareup.spoon.DeviceDetails;
import com.squareup.spoon.DeviceTest;
import com.squareup.spoon.DeviceTestResult;
import com.squareup.spoon.misc.StackTrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public final class DeviceResult {
    private final boolean installFailed;
    private final String installMessage;
    private final DeviceDetails deviceDetails;
    private final Map<DeviceTest, DeviceTestResult> testResults;
    private final long started;
    private final long duration;
    private final List<StackTrace> exceptions;

    private DeviceResult(boolean installFailed, String installMessage, DeviceDetails deviceDetails, Map<DeviceTest, DeviceTestResult> testResults, long started, long duration, List<StackTrace> exceptions) {
        this.installFailed = installFailed;
        this.installMessage = installMessage;
        this.deviceDetails = deviceDetails;
        this.started = started;
        this.testResults = Collections.unmodifiableMap(new TreeMap<DeviceTest, DeviceTestResult>(testResults));
        this.duration = duration;
        this.exceptions = Collections.unmodifiableList(new ArrayList<StackTrace>(exceptions));
    }

    public boolean getInstallFailed() {
        return this.installFailed;
    }

    public String getInstallMessage() {
        return this.installMessage;
    }

    public DeviceDetails getDeviceDetails() {
        return this.deviceDetails;
    }

    public Map<DeviceTest, DeviceTestResult> getTestResults() {
        return this.testResults;
    }

    public long getStarted() {
        return this.started;
    }

    public long getDuration() {
        return this.duration;
    }

    public List<StackTrace> getExceptions() {
        return this.exceptions;
    }

    static class Builder {
        private boolean installFailed = false;
        private String installMessage = null;
        private final Map<DeviceTest, DeviceTestResult.Builder> testResultBuilders = new HashMap<DeviceTest, DeviceTestResult.Builder>();
        private DeviceDetails deviceDetails = null;
        private final long started = new Date().getTime();
        private long start;
        private long duration = -1L;
        private final List<StackTrace> exceptions = new ArrayList<StackTrace>();

        Builder() {
        }

        public Builder addTestResultBuilder(DeviceTest test, DeviceTestResult.Builder methodResultBuilder) {
            Preconditions.checkArgument((!this.installFailed ? 1 : 0) != 0, (Object)"Cannot add test result builder when install failed.");
            Preconditions.checkNotNull((Object)methodResultBuilder);
            this.testResultBuilders.put(test, methodResultBuilder);
            return this;
        }

        public DeviceTestResult.Builder getMethodResultBuilder(DeviceTest test) {
            return this.testResultBuilders.get(test);
        }

        public Builder setDeviceDetails(DeviceDetails deviceDetails) {
            Preconditions.checkNotNull((Object)deviceDetails);
            this.deviceDetails = deviceDetails;
            return this;
        }

        public Builder markInstallAsFailed(String message) {
            Preconditions.checkNotNull((Object)message);
            Preconditions.checkArgument((!this.installFailed ? 1 : 0) != 0, (Object)"Install already marked as failed.");
            this.installFailed = true;
            this.installMessage = message;
            return this;
        }

        public Builder startTests() {
            Preconditions.checkArgument((!this.installFailed ? 1 : 0) != 0, (Object)"Cannot start tests when install failed.");
            Preconditions.checkArgument((this.start == 0L ? 1 : 0) != 0, (Object)"Start already called.");
            this.start = System.nanoTime();
            return this;
        }

        public Builder endTests() {
            Preconditions.checkArgument((this.start != 0L ? 1 : 0) != 0, (Object)"Start was not called.");
            Preconditions.checkArgument((this.duration == -1L ? 1 : 0) != 0, (Object)"End was already called.");
            this.duration = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start);
            return this;
        }

        public Builder addException(Throwable throwable) {
            Preconditions.checkNotNull((Object)throwable);
            this.exceptions.add(StackTrace.from(throwable));
            return this;
        }

        public Builder addException(String message) {
            Preconditions.checkNotNull((Object)message);
            this.exceptions.add(StackTrace.from(message));
            return this;
        }

        public DeviceResult build() {
            HashMap<DeviceTest, DeviceTestResult> testResults = new HashMap<DeviceTest, DeviceTestResult>();
            for (Map.Entry<DeviceTest, DeviceTestResult.Builder> entry : this.testResultBuilders.entrySet()) {
                testResults.put(entry.getKey(), entry.getValue().build());
            }
            return new DeviceResult(this.installFailed, this.installMessage, this.deviceDetails, testResults, this.started, this.duration, this.exceptions);
        }
    }
}

