/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.testrunner.TestIdentifier;
import com.google.common.base.Preconditions;

public final class DeviceTest
implements Comparable<DeviceTest> {
    private final String className;
    private final String methodName;

    static DeviceTest from(TestIdentifier testIdentifier) {
        return new DeviceTest(testIdentifier.getClassName(), testIdentifier.getTestName());
    }

    DeviceTest(String className, String methodName) {
        Preconditions.checkNotNull((Object)className);
        Preconditions.checkNotNull((Object)methodName);
        this.className = className;
        this.methodName = methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceTest that = (DeviceTest)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        return this.methodName.equals(that.methodName);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        return result;
    }

    public String toString() {
        return this.className + "#" + this.methodName;
    }

    @Override
    public int compareTo(DeviceTest other) {
        int classCompare = this.className.compareTo(other.className);
        if (classCompare != 0) {
            return classCompare;
        }
        return this.methodName.compareTo(other.methodName);
    }
}

