/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon.html;

import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.squareup.spoon.DeviceDetails;
import com.squareup.spoon.DeviceResult;
import com.squareup.spoon.DeviceTest;
import com.squareup.spoon.DeviceTestResult;
import com.squareup.spoon.SpoonSummary;
import com.squareup.spoon.html.HtmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

final class HtmlIndex {
    public final String title;
    public final String subtitle;
    public final int testCount;
    public final List<Device> devices;

    static HtmlIndex from(SpoonSummary summary) {
        int testsRun = 0;
        int totalSuccess = 0;
        LinkedHashSet<DeviceTest> tests = new LinkedHashSet<DeviceTest>();
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Map.Entry<String, DeviceResult> result : summary.getResults().entrySet()) {
            devices.add(Device.from(result.getKey(), result.getValue()));
            Map<DeviceTest, DeviceTestResult> testResults = result.getValue().getTestResults();
            testsRun += testResults.size();
            for (Map.Entry<DeviceTest, DeviceTestResult> entry : testResults.entrySet()) {
                tests.add(entry.getKey());
                if (entry.getValue().getStatus() != DeviceTestResult.Status.PASS) continue;
                ++totalSuccess;
            }
        }
        Collections.sort(devices);
        int totalFailure = testsRun - totalSuccess;
        int deviceCount = summary.getResults().size();
        IRemoteAndroidTestRunner.TestSize testSize = summary.getTestSize();
        String started = HtmlUtils.dateToString(summary.getStarted());
        String totalTestsRun = testsRun + (testSize != null ? " " + testSize.name().toLowerCase() : "") + " test" + (testsRun != 1 ? "s" : "");
        String totalDevices = deviceCount + " device" + (deviceCount != 1 ? "s" : "");
        StringBuilder subtitle = new StringBuilder();
        subtitle.append(totalTestsRun).append(" run across ").append(totalDevices);
        if (testsRun > 0) {
            subtitle.append(" with ").append(totalSuccess).append(" passing and ").append(totalFailure).append(" failing in ").append(HtmlUtils.humanReadableDuration(summary.getDuration()));
        }
        subtitle.append(" at ").append(started);
        return new HtmlIndex(summary.getTitle(), subtitle.toString(), tests.size(), devices);
    }

    HtmlIndex(String title, String subtitle, int testCount, List<Device> devices) {
        this.title = title;
        this.subtitle = subtitle;
        this.testCount = testCount;
        this.devices = devices;
    }

    static final class TestResult
    implements Comparable<TestResult> {
        public final String serial;
        public final String classSimpleName;
        public final String prettyMethodName;
        public final String testId;
        public final String status;

        static TestResult from(String serial, DeviceTest test, DeviceTestResult testResult) {
            String className = test.getClassName();
            String methodName = test.getMethodName();
            String classSimpleName = HtmlUtils.getClassSimpleName(className);
            String prettyMethodName = HtmlUtils.prettifyMethodName(methodName);
            String testId = HtmlUtils.testClassAndMethodToId(className, methodName);
            String status = HtmlUtils.getStatusCssClass(testResult);
            return new TestResult(serial, classSimpleName, prettyMethodName, testId, status);
        }

        TestResult(String serial, String classSimpleName, String prettyMethodName, String testId, String status) {
            this.serial = serial;
            this.classSimpleName = classSimpleName;
            this.prettyMethodName = prettyMethodName;
            this.testId = testId;
            this.status = status;
        }

        @Override
        public int compareTo(TestResult other) {
            return 0;
        }
    }

    static final class Device
    implements Comparable<Device> {
        public final String serial;
        public final String name;
        public final List<TestResult> testResults;
        public final boolean executionFailed;

        static Device from(String serial, DeviceResult result) {
            ArrayList<TestResult> testResults = new ArrayList<TestResult>();
            for (Map.Entry<DeviceTest, DeviceTestResult> entry : result.getTestResults().entrySet()) {
                testResults.add(TestResult.from(serial, entry.getKey(), entry.getValue()));
            }
            DeviceDetails details = result.getDeviceDetails();
            String name = details != null ? details.getName() : serial;
            boolean executionFailed = testResults.isEmpty() && !result.getExceptions().isEmpty();
            return new Device(serial, name, testResults, executionFailed);
        }

        Device(String serial, String name, List<TestResult> testResults, boolean executionFailed) {
            this.serial = serial;
            this.name = name;
            this.testResults = testResults;
            this.executionFailed = executionFailed;
        }

        @Override
        public int compareTo(Device other) {
            if (this.name == null && other.name == null) {
                return this.serial.compareTo(other.serial);
            }
            if (this.name == null) {
                return 1;
            }
            if (other.name == null) {
                return -1;
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name != null ? this.name : this.serial;
        }
    }
}

