/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon.html;

import com.squareup.spoon.DeviceDetails;
import com.squareup.spoon.DeviceTestResult;
import com.squareup.spoon.misc.StackTrace;
import java.io.File;
import java.io.IOException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FilenameUtils;

final class HtmlUtils {
    private static final String INVALID_ID_CHARS = "[^a-zA-Z0-9]";
    private static final ThreadLocal<Format> DATE_FORMAT = new ThreadLocal<Format>(){

        @Override
        protected Format initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd hh:mm a");
        }
    };
    private static final ThreadLocal<Format> DATE_FORMAT_TV = new ThreadLocal<Format>(){

        @Override
        protected Format initialValue() {
            return new SimpleDateFormat("EEEE, MMMM dd, h:mm a");
        }
    };

    HtmlUtils() {
    }

    static String deviceDetailsToString(DeviceDetails details) {
        if (details == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Running Android ").append(details.getVersion()).append(" (API ").append(details.getApiLevel()).append(")");
        if (details.getLanguage() != null || details.getRegion() != null) {
            builder.append(" with locale ");
            if (details.getLanguage() != null) {
                builder.append(details.getLanguage());
                if (details.getRegion() != null) {
                    builder.append("-");
                }
                if (details.getRegion() != null) {
                    builder.append(details.getRegion());
                }
            }
        }
        return builder.toString();
    }

    static String dateToString(long date) {
        return DATE_FORMAT.get().format(new Date(date));
    }

    public static String dateToTvString(long date) {
        return DATE_FORMAT_TV.get().format(new Date(date));
    }

    static String testClassAndMethodToId(String className, String methodName) {
        return className.replaceAll(INVALID_ID_CHARS, "-") + "-" + methodName.replaceAll(INVALID_ID_CHARS, "-");
    }

    static String getClassSimpleName(String className) {
        int lastPeriod = className.lastIndexOf(".");
        if (lastPeriod != -1) {
            return className.substring(lastPeriod + 1);
        }
        return className;
    }

    static String getStatusCssClass(DeviceTestResult testResult) {
        String status;
        switch (testResult.getStatus()) {
            case PASS: {
                status = "pass";
                break;
            }
            case FAIL: {
                status = "fail";
                break;
            }
            case ERROR: {
                status = "error";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown result status: " + (Object)((Object)testResult.getStatus()));
            }
        }
        return status;
    }

    static String prettifyMethodName(String methodName) {
        String[] parts;
        if (methodName.startsWith("test")) {
            methodName = methodName.substring(4);
        } else if (Character.isLowerCase(methodName.charAt(0))) {
            methodName = Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        }
        StringBuilder pretty = new StringBuilder();
        for (String part : parts = methodName.split("_")) {
            if ("".equals(part.trim())) continue;
            if (pretty.length() > 0) {
                pretty.append(",");
            }
            boolean inUpper = true;
            for (char letter : part.toCharArray()) {
                boolean isUpper = Character.isUpperCase(letter);
                if (!isUpper && inUpper && pretty.length() > 1 && pretty.charAt(pretty.length() - 2) != ' ') {
                    pretty.insert(pretty.length() - 1, " ");
                } else if (isUpper && !inUpper) {
                    pretty.append(" ");
                }
                inUpper = isUpper;
                pretty.append(letter);
            }
        }
        return pretty.toString();
    }

    static String prettifyImageName(String imageName) {
        imageName = FilenameUtils.removeExtension((String)imageName);
        imageName = imageName.split("_", 2)[1];
        StringBuilder pretty = new StringBuilder();
        for (String part : imageName.replace('_', '-').split("-")) {
            if ("".equals(part.trim())) continue;
            pretty.append(Character.toUpperCase(part.charAt(0)));
            pretty.append(part, 1, part.length());
            pretty.append(" ");
        }
        return pretty.deleteCharAt(pretty.length() - 1).toString();
    }

    static String createRelativeUri(File file, File output) {
        if (file == null) {
            return null;
        }
        try {
            file = file.getCanonicalFile();
            output = output.getCanonicalFile();
            if (file.equals(output)) {
                throw new IllegalArgumentException("File path and output folder are the same.");
            }
            StringBuilder builder = new StringBuilder();
            while (!file.equals(output)) {
                if (builder.length() > 0) {
                    builder.insert(0, "/");
                }
                builder.insert(0, file.getName());
                file = file.getParentFile().getCanonicalFile();
            }
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Screenshot getScreenshot(File screenshot, File output) {
        String relativePath = HtmlUtils.createRelativeUri(screenshot, output);
        String caption = HtmlUtils.prettifyImageName(screenshot.getName());
        return new Screenshot(relativePath, caption);
    }

    public static SavedFile getFile(File file, File output) {
        return new SavedFile(HtmlUtils.createRelativeUri(file, output), file.getName());
    }

    static ExceptionInfo processStackTrace(StackTrace exception) {
        if (exception == null) {
            return null;
        }
        String message = exception.toString().replace("\n", "<br/>");
        ArrayList<String> lines = new ArrayList<String>();
        for (StackTrace.Element element : exception.getElements()) {
            lines.add("&nbsp;&nbsp;&nbsp;&nbsp;at " + element.toString());
        }
        while (exception.getCause() != null) {
            exception = exception.getCause();
            lines.add("Caused by: " + exception.toString().replace("\n", "<br/>"));
        }
        return new ExceptionInfo(message, lines);
    }

    static String humanReadableDuration(long length) {
        long minutes = length / 60L;
        long seconds = length - minutes * 60L;
        StringBuilder builder = new StringBuilder();
        if (minutes != 0L) {
            builder.append(minutes).append(" minute");
            if (minutes != 1L) {
                builder.append("s");
            }
        }
        if (seconds != 0L || minutes == 0L) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(seconds).append(" second");
            if (seconds != 1L) {
                builder.append("s");
            }
        }
        return builder.toString();
    }

    static final class ExceptionInfo {
        private static final AtomicLong ID = new AtomicLong(0L);
        public final long id = ID.getAndIncrement();
        public final String title;
        public final List<String> body;

        ExceptionInfo(String title, List<String> body) {
            this.title = title;
            this.body = body;
        }
    }

    static final class SavedFile {
        private static final AtomicLong ID = new AtomicLong(0L);
        private final long id = ID.incrementAndGet();
        public final String path;
        public final String name;

        SavedFile(String path, String name) {
            this.path = path;
            this.name = name;
        }
    }

    static final class Screenshot {
        private static final AtomicLong ID = new AtomicLong(0L);
        public final long id = ID.getAndIncrement();
        public final String path;
        public final String caption;

        Screenshot(String path, String caption) {
            this.path = path;
            this.caption = caption;
        }
    }
}

