/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.IParameterSplitter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.squareup.spoon.DeviceResult;
import com.squareup.spoon.DeviceTestResult;
import com.squareup.spoon.SpoonCoverageMerger;
import com.squareup.spoon.SpoonDeviceRunner;
import com.squareup.spoon.SpoonInstrumentationInfo;
import com.squareup.spoon.SpoonLogger;
import com.squareup.spoon.SpoonSummary;
import com.squareup.spoon.SpoonUtils;
import com.squareup.spoon.html.HtmlRenderer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;

public final class SpoonRunner {
    private static final String DEFAULT_TITLE = "Spoon Execution";
    public static final String DEFAULT_OUTPUT_DIRECTORY = "spoon-output";
    private static final int DEFAULT_ADB_TIMEOUT_SEC = 600;
    private final ExecutorService threadExecutor;
    private final String title;
    private final File androidSdk;
    private final File applicationApk;
    private final File instrumentationApk;
    private final File output;
    private final boolean debug;
    private final boolean noAnimations;
    private final int adbTimeoutMillis;
    private final List<String> instrumentationArgs;
    private final String className;
    private final String methodName;
    private final Set<String> serials;
    private final boolean shard;
    private final String classpath;
    private final IRemoteAndroidTestRunner.TestSize testSize;
    private boolean codeCoverage;
    private final boolean failIfNoDeviceConnected;
    private final List<ITestRunListener> testRunListeners;
    private final boolean terminateAdb;
    private File initScript;

    private SpoonRunner(String title, File androidSdk, File applicationApk, File instrumentationApk, File output, boolean debug, boolean noAnimations, int adbTimeoutMillis, Set<String> serials, boolean shard, String classpath, List<String> instrumentationArgs, String className, String methodName, IRemoteAndroidTestRunner.TestSize testSize, boolean failIfNoDeviceConnected, List<ITestRunListener> testRunListeners, boolean sequential, File initScript, boolean terminateAdb, boolean codeCoverage) {
        this.title = title;
        this.androidSdk = androidSdk;
        this.applicationApk = applicationApk;
        this.instrumentationApk = instrumentationApk;
        this.output = output;
        this.debug = debug;
        this.noAnimations = noAnimations;
        this.adbTimeoutMillis = adbTimeoutMillis;
        this.instrumentationArgs = instrumentationArgs;
        this.className = className;
        this.methodName = methodName;
        this.classpath = classpath;
        this.testSize = testSize;
        this.codeCoverage = codeCoverage;
        this.serials = ImmutableSet.copyOf(serials);
        this.shard = shard;
        this.failIfNoDeviceConnected = failIfNoDeviceConnected;
        this.testRunListeners = testRunListeners;
        this.terminateAdb = terminateAdb;
        this.initScript = initScript;
        this.threadExecutor = sequential ? Executors.newSingleThreadExecutor() : Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        Preconditions.checkArgument((boolean)this.applicationApk.exists(), (Object)"Could not find application APK.");
        Preconditions.checkArgument((boolean)this.instrumentationApk.exists(), (Object)"Could not find instrumentation APK.");
        AndroidDebugBridge adb = SpoonUtils.initAdb(this.androidSdk, this.adbTimeoutMillis);
        try {
            SpoonInstrumentationInfo testInfo = SpoonInstrumentationInfo.parseFromFile(this.instrumentationApk);
            Set<String> serials = this.serials;
            if (serials.isEmpty()) {
                serials = SpoonUtils.findAllDevices(adb, testInfo.getMinSdkVersion());
            }
            if (this.failIfNoDeviceConnected && serials.isEmpty()) {
                throw new RuntimeException("No device(s) found.");
            }
            SpoonSummary summary = this.runTests(adb, serials);
            new HtmlRenderer(summary, SpoonUtils.GSON, this.output).render();
            boolean bl = SpoonRunner.parseOverallSuccess(summary);
            return bl;
        }
        finally {
            if (this.terminateAdb) {
                AndroidDebugBridge.terminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpoonSummary runTests(AndroidDebugBridge adb, Set<String> serials) {
        SpoonSummary.Builder summary;
        block17: {
            SpoonInstrumentationInfo testInfo;
            int targetCount;
            block18: {
                targetCount = serials.size();
                SpoonLogger.logInfo("Executing instrumentation suite on %d device(s).", targetCount);
                try {
                    FileUtils.deleteDirectory((File)this.output);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to clean output directory: " + this.output, e);
                }
                testInfo = SpoonInstrumentationInfo.parseFromFile(this.instrumentationApk);
                SpoonLogger.logDebug(this.debug, "Application: %s from %s", testInfo.getApplicationPackage(), this.applicationApk.getAbsolutePath());
                SpoonLogger.logDebug(this.debug, "Instrumentation: %s from %s", testInfo.getInstrumentationPackage(), this.instrumentationApk.getAbsolutePath());
                summary = new SpoonSummary.Builder().setTitle(this.title).start();
                if (this.testSize != null) {
                    summary.setTestSize(this.testSize);
                }
                if (targetCount != 1) break block18;
                this.executeInitScript();
                String serial = serials.iterator().next();
                String safeSerial = SpoonUtils.sanitizeSerial(serial);
                try {
                    SpoonLogger.logDebug(this.debug, "[%s] Starting execution.", serial);
                    summary.addResult(safeSerial, this.getTestRunner(serial, 0, 0, testInfo).run(adb));
                }
                catch (Exception e) {
                    try {
                        SpoonLogger.logDebug(this.debug, "[%s] Execution exception!", serial);
                        e.printStackTrace(System.out);
                        summary.addResult(safeSerial, new DeviceResult.Builder().addException(e).build());
                    }
                    catch (Throwable throwable) {
                        SpoonLogger.logDebug(this.debug, "[%s] Execution done.", serial);
                        throw throwable;
                    }
                    SpoonLogger.logDebug(this.debug, "[%s] Execution done.", serial);
                    break block17;
                }
                SpoonLogger.logDebug(this.debug, "[%s] Execution done.", serial);
                break block17;
            }
            this.threadExecutor.execute(this.getRunnableScript());
            final CountDownLatch done = new CountDownLatch(targetCount);
            final Set<String> remaining = Collections.synchronizedSet(new HashSet<String>(serials));
            int shardIndex = 0;
            final int numShards = this.shard ? serials.size() : 0;
            for (final String serial : serials) {
                final String safeSerial = SpoonUtils.sanitizeSerial(serial);
                SpoonLogger.logDebug(this.debug, "[%s] Starting execution.", serial);
                final int safeShardIndex = shardIndex++;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            summary.addResult(safeSerial, SpoonRunner.this.getTestRunner(serial, safeShardIndex, numShards, testInfo).runInNewProcess());
                            done.countDown();
                            remaining.remove(serial);
                        }
                        catch (Exception e) {
                            try {
                                e.printStackTrace(System.out);
                                summary.addResult(safeSerial, new DeviceResult.Builder().addException(e).build());
                                done.countDown();
                                remaining.remove(serial);
                            }
                            catch (Throwable throwable) {
                                done.countDown();
                                remaining.remove(serial);
                                SpoonLogger.logDebug(SpoonRunner.this.debug, "[%s] Execution done. (%s remaining %s)", serial, done.getCount(), remaining);
                                throw throwable;
                            }
                            SpoonLogger.logDebug(SpoonRunner.this.debug, "[%s] Execution done. (%s remaining %s)", serial, done.getCount(), remaining);
                        }
                        SpoonLogger.logDebug(SpoonRunner.this.debug, "[%s] Execution done. (%s remaining %s)", serial, done.getCount(), remaining);
                    }
                };
                if (this.shard) {
                    SpoonLogger.logDebug(this.debug, "shardIndex [%d]", shardIndex);
                }
                this.threadExecutor.execute(runnable);
            }
            try {
                done.await();
                this.threadExecutor.shutdown();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.codeCoverage) {
            SpoonCoverageMerger coverageMerger = new SpoonCoverageMerger();
            try {
                coverageMerger.mergeCoverageFiles(serials, this.output);
                SpoonLogger.logDebug(this.debug, "Merging of coverage files done.", new Object[0]);
            }
            catch (IOException exception) {
                throw new RuntimeException("error while merging coverage files", exception);
            }
        }
        if (!this.debug) {
            try {
                FileUtils.deleteDirectory((File)new File(this.output, "work"));
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return summary.end().build();
    }

    private Runnable getRunnableScript() {
        return new Runnable(){

            @Override
            public void run() {
                SpoonRunner.this.executeInitScript();
            }
        };
    }

    private void executeInitScript() {
        if (this.initScript != null && this.initScript.exists()) {
            try {
                String line;
                Runtime run = Runtime.getRuntime();
                Process proc = run.exec(new String[]{"/bin/bash", "-c", this.initScript.getAbsolutePath()});
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                SpoonLogger.logInfo("Output of running script is", new Object[0]);
                while ((line = br.readLine()) != null) {
                    SpoonLogger.logInfo(line, new Object[0]);
                }
                proc.waitFor();
                SpoonLogger.logInfo("Script executed successfully %s", this.initScript.getAbsolutePath());
            }
            catch (IOException e) {
                SpoonLogger.logDebug(this.debug, "Error executing script for path: %s", this.initScript.getAbsolutePath());
                e.printStackTrace(System.out);
            }
            catch (InterruptedException e) {
                SpoonLogger.logDebug(this.debug, "Script execution interrupted for path: %s", this.initScript.getAbsolutePath());
                e.printStackTrace(System.out);
            }
        }
    }

    static boolean parseOverallSuccess(SpoonSummary summary) {
        for (DeviceResult result : summary.getResults().values()) {
            if (result.getInstallFailed()) {
                return false;
            }
            if (!result.getExceptions().isEmpty() && result.getTestResults().isEmpty()) {
                return false;
            }
            for (DeviceTestResult methodResult : result.getTestResults().values()) {
                if (methodResult.getStatus() == DeviceTestResult.Status.PASS) continue;
                return false;
            }
        }
        return true;
    }

    private SpoonDeviceRunner getTestRunner(String serial, int shardIndex, int numShards, SpoonInstrumentationInfo testInfo) {
        return new SpoonDeviceRunner(this.androidSdk, this.applicationApk, this.instrumentationApk, this.output, serial, shardIndex, numShards, this.debug, this.noAnimations, this.adbTimeoutMillis, this.classpath, testInfo, this.instrumentationArgs, this.className, this.methodName, this.testSize, this.testRunListeners, this.codeCoverage);
    }

    private static File cleanFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public static void main(String ... args) {
        CommandLineArgs parsedArgs = new CommandLineArgs();
        JCommander jc = new JCommander((Object)parsedArgs);
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            StringBuilder out = new StringBuilder(e.getLocalizedMessage()).append("\n\n");
            jc.usage(out);
            System.err.println(out.toString());
            System.exit(1);
            return;
        }
        if (parsedArgs.help) {
            jc.usage();
            return;
        }
        Builder builder = new Builder().setTitle(parsedArgs.title).setApplicationApk(parsedArgs.apk).setInstrumentationApk(parsedArgs.testApk).setOutputDirectory(parsedArgs.output).setDebug(parsedArgs.debug).setAndroidSdk(parsedArgs.sdk).setNoAnimations(parsedArgs.noAnimations).setTestSize(parsedArgs.size).setAdbTimeout(parsedArgs.adbTimeoutSeconds * 1000).setFailIfNoDeviceConnected(parsedArgs.failIfNoDeviceConnected).setSequential(parsedArgs.sequential).setInitScript(parsedArgs.initScript).setInstrumentationArgs(parsedArgs.instrumentationArgs).setCodeCoverage(parsedArgs.codeCoverage).setClassName(parsedArgs.className).setMethodName(parsedArgs.methodName).setShard(parsedArgs.shard);
        if (parsedArgs.serials == null || parsedArgs.serials.isEmpty()) {
            builder.useAllAttachedDevices();
        } else {
            for (String serial : parsedArgs.serials) {
                builder.addDevice(serial);
            }
        }
        SpoonRunner spoonRunner = builder.build();
        if (!spoonRunner.run() && parsedArgs.failOnFailure) {
            System.exit(1);
        }
    }

    public static class TestSizeConverter
    implements IStringConverter<IRemoteAndroidTestRunner.TestSize> {
        public IRemoteAndroidTestRunner.TestSize convert(String value) {
            try {
                return IRemoteAndroidTestRunner.TestSize.getTestSize((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(e.getMessage());
            }
        }
    }

    public static class FileConverter
    implements IStringConverter<File> {
        public File convert(String s) {
            return SpoonRunner.cleanFile(s);
        }
    }

    static class CommandLineArgs {
        @Parameter(names={"--title"}, description="Execution title")
        public String title = "Spoon Execution";
        @Parameter(names={"--apk"}, description="Application APK", converter=FileConverter.class, required=true)
        public File apk;
        @Parameter(names={"--test-apk"}, description="Test application APK", converter=FileConverter.class, required=true)
        public File testApk;
        @Parameter(names={"--e"}, variableArity=true, splitter=NoSplitter.class, description="Arguments to pass to the Instrumentation Runner. This can be used multiple times for multiple entries. Usage: --e <NAME>=<VALUE>.")
        public List<String> instrumentationArgs;
        @Parameter(names={"--class-name"}, description="Test class name to run (fully-qualified)")
        public String className;
        @Parameter(names={"--method-name"}, description="Test method name to run (must also use --class-name)")
        public String methodName;
        @Parameter(names={"--size"}, converter=TestSizeConverter.class, description="Only run methods with corresponding size annotation (small, medium, large)")
        public IRemoteAndroidTestRunner.TestSize size;
        @Parameter(names={"--output"}, description="Output path", converter=FileConverter.class)
        public File output = SpoonRunner.access$400("spoon-output");
        @Parameter(names={"--sdk"}, description="Path to Android SDK")
        public File sdk = SpoonRunner.access$400(System.getenv("ANDROID_HOME"));
        @Parameter(names={"--fail-on-failure"}, description="Non-zero exit code on failure")
        public boolean failOnFailure;
        @Parameter(names={"--fail-if-no-device-connected"}, description="Fail if no device is connected")
        public boolean failIfNoDeviceConnected;
        @Parameter(names={"--sequential"}, description="Execute tests sequentially (one device at a time)")
        public boolean sequential;
        @Parameter(names={"--init-script"}, description="Script file executed between each devices", converter=FileConverter.class)
        public File initScript;
        @Parameter(names={"--no-animations"}, description="Disable animated gif generation")
        public boolean noAnimations;
        @Parameter(names={"--adb-timeout"}, description="Set maximum execution time per test in seconds (10min default)")
        public int adbTimeoutSeconds = 600;
        @Parameter(names={"-serial"}, description="Serial of the device to use (May be used multiple times)")
        private List<String> serials = new ArrayList<String>();
        @Parameter(names={"--shard"}, description="Automatically shard across all specified serials")
        public boolean shard;
        @Parameter(names={"--debug"}, hidden=true)
        public boolean debug;
        @Parameter(names={"--coverage"}, description="Code coverage flag", arity=1)
        public Boolean codeCoverage = false;
        @Parameter(names={"-h", "--help"}, description="Command help", help=true, hidden=true)
        public boolean help;

        CommandLineArgs() {
        }
    }

    public static class NoSplitter
    implements IParameterSplitter {
        public List<String> split(String value) {
            return Collections.singletonList(value);
        }
    }

    public static class Builder {
        private String title = "Spoon Execution";
        private File androidSdk;
        private File applicationApk;
        private File instrumentationApk;
        private File output;
        private boolean debug = false;
        private Set<String> serials;
        private String classpath = System.getProperty("java.class.path");
        private List<String> instrumentationArgs;
        private String className;
        private String methodName;
        private boolean noAnimations;
        private IRemoteAndroidTestRunner.TestSize testSize;
        private int adbTimeoutMillis = 600000;
        private boolean failIfNoDeviceConnected;
        private List<ITestRunListener> testRunListeners = new ArrayList<ITestRunListener>();
        private boolean sequential;
        private File initScript;
        private boolean terminateAdb = true;
        private boolean codeCoverage;
        private boolean shard = false;

        public Builder setTitle(String title) {
            Preconditions.checkNotNull((Object)title, (Object)"Title cannot be null.");
            this.title = title;
            return this;
        }

        public Builder setAndroidSdk(File androidSdk) {
            Preconditions.checkNotNull((Object)androidSdk, (Object)"SDK path not specified.");
            Preconditions.checkArgument((boolean)androidSdk.exists(), (Object)"SDK path does not exist.");
            this.androidSdk = androidSdk;
            return this;
        }

        public Builder setApplicationApk(File apk) {
            Preconditions.checkNotNull((Object)apk, (Object)"APK path not specified.");
            Preconditions.checkArgument((boolean)apk.exists(), (Object)"APK path does not exist.");
            this.applicationApk = apk;
            return this;
        }

        public Builder setInstrumentationApk(File apk) {
            Preconditions.checkNotNull((Object)apk, (Object)"Instrumentation APK path not specified.");
            Preconditions.checkArgument((boolean)apk.exists(), (Object)"Instrumentation APK path does not exist.");
            this.instrumentationApk = apk;
            return this;
        }

        public Builder setOutputDirectory(File output) {
            Preconditions.checkNotNull((Object)output, (Object)"Output directory not specified.");
            this.output = output;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder setNoAnimations(boolean noAnimations) {
            this.noAnimations = noAnimations;
            return this;
        }

        public Builder setAdbTimeout(int value) {
            this.adbTimeoutMillis = value;
            return this;
        }

        public Builder addDevice(String serial) {
            Preconditions.checkNotNull((Object)serial, (Object)"Serial cannot be null.");
            Preconditions.checkArgument((this.serials == null || !this.serials.isEmpty() ? 1 : 0) != 0, (Object)"Already marked as using all devices.");
            if (this.serials == null) {
                this.serials = new LinkedHashSet<String>();
            }
            this.serials.add(serial);
            return this;
        }

        public Builder useAllAttachedDevices() {
            if (this.serials != null) {
                throw new IllegalStateException("Serial list already contains entries.");
            }
            if (this.androidSdk == null) {
                throw new IllegalStateException("SDK must be set before calling this method.");
            }
            this.serials = Collections.emptySet();
            return this;
        }

        public Builder setClasspath(String classpath) {
            Preconditions.checkNotNull((Object)classpath, (Object)"Classpath cannot be null.");
            this.classpath = classpath;
            return this;
        }

        public Builder setInstrumentationArgs(List<String> instrumentationArgs) {
            this.instrumentationArgs = instrumentationArgs;
            return this;
        }

        public Builder setClassName(String className) {
            this.className = className;
            return this;
        }

        public Builder setTestSize(IRemoteAndroidTestRunner.TestSize testSize) {
            this.testSize = testSize;
            return this;
        }

        public Builder setFailIfNoDeviceConnected(boolean failIfNoDeviceConnected) {
            this.failIfNoDeviceConnected = failIfNoDeviceConnected;
            return this;
        }

        public Builder setSequential(boolean sequential) {
            this.sequential = sequential;
            return this;
        }

        public Builder setInitScript(File initScript) {
            if (initScript != null) {
                Preconditions.checkArgument((boolean)initScript.exists(), (Object)("Script path does not exist " + initScript.getAbsolutePath()));
            }
            this.initScript = initScript;
            return this;
        }

        public Builder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder setCodeCoverage(boolean codeCoverage) {
            this.codeCoverage = codeCoverage;
            return this;
        }

        public Builder setShard(boolean shard) {
            this.shard = shard;
            return this;
        }

        public Builder addTestRunListener(ITestRunListener testRunListener) {
            Preconditions.checkNotNull((Object)testRunListener, (Object)"TestRunListener cannot be null.");
            this.testRunListeners.add(testRunListener);
            return this;
        }

        public Builder setTerminateAdb(boolean terminateAdb) {
            this.terminateAdb = terminateAdb;
            return this;
        }

        public SpoonRunner build() {
            Preconditions.checkNotNull((Object)this.androidSdk, (Object)"SDK is required.");
            Preconditions.checkArgument((boolean)this.androidSdk.exists(), (Object)"SDK path does not exist.");
            Preconditions.checkNotNull((Object)this.applicationApk, (Object)"Application APK is required.");
            Preconditions.checkNotNull((Object)this.instrumentationApk, (Object)"Instrumentation APK is required.");
            Preconditions.checkNotNull((Object)this.output, (Object)"Output path is required.");
            Preconditions.checkNotNull(this.serials, (Object)"Device serials are required.");
            if (!Strings.isNullOrEmpty((String)this.methodName)) {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.className) ? 1 : 0) != 0, (Object)"Must specify class name if you're specifying a method name.");
            }
            return new SpoonRunner(this.title, this.androidSdk, this.applicationApk, this.instrumentationApk, this.output, this.debug, this.noAnimations, this.adbTimeoutMillis, this.serials, this.shard, this.classpath, this.instrumentationArgs, this.className, this.methodName, this.testSize, this.failIfNoDeviceConnected, this.testRunListeners, this.sequential, this.initScript, this.terminateAdb, this.codeCoverage);
        }
    }
}

