/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.madgag.gif.fmsware.AnimatedGifEncoder;
import com.squareup.spoon.DeviceDetails;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public final class SpoonUtils {
    private static final Pattern SERIAL_VALIDATION = Pattern.compile("[^a-zA-Z0-9_-]");
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(File.class, (Object)new TypeAdapter<File>(){

        public void write(JsonWriter jsonWriter, File file) throws IOException {
            if (file == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.value(file.getAbsolutePath());
            }
        }

        public File read(JsonReader jsonReader) throws IOException {
            return new File(jsonReader.nextString());
        }
    }).enableComplexMapKeySerialization().setPrettyPrinting().create();

    static IDevice obtainRealDevice(AndroidDebugBridge adb, String serial) {
        for (IDevice adbDevice : adb.getDevices()) {
            if (!adbDevice.getSerialNumber().equals(serial)) continue;
            return adbDevice;
        }
        throw new IllegalArgumentException("Unknown device serial: " + serial);
    }

    static String sanitizeSerial(String serial) {
        return SERIAL_VALIDATION.matcher(serial).replaceAll("_");
    }

    static FileListingService.FileEntry obtainDirectoryFileEntry(String path) {
        try {
            FileListingService.FileEntry lastEntry = null;
            Constructor c = FileListingService.FileEntry.class.getDeclaredConstructor(FileListingService.FileEntry.class, String.class, Integer.TYPE, Boolean.TYPE);
            c.setAccessible(true);
            for (String part : path.split("/")) {
                lastEntry = (FileListingService.FileEntry)c.newInstance(lastEntry, part, 1, lastEntry == null);
            }
            return lastEntry;
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (InvocationTargetException ignored) {
        }
        catch (InstantiationException ignored) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    static void setDdmlibInternalLoggingLevel() {
        DdmPreferences.setLogLevel((String)"debug");
    }

    public static Set<String> findAllDevices(AndroidDebugBridge adb) {
        return SpoonUtils.findAllDevices(adb, null);
    }

    public static Set<String> findAllDevices(AndroidDebugBridge adb, Integer minApiLevel) {
        LinkedHashSet<String> devices = new LinkedHashSet<String>();
        for (IDevice realDevice : adb.getDevices()) {
            if (minApiLevel == null) {
                devices.add(realDevice.getSerialNumber());
                continue;
            }
            DeviceDetails deviceDetails = DeviceDetails.createForDevice(realDevice);
            int apiLevel = deviceDetails.getApiLevel();
            if (apiLevel != 0 && apiLevel < minApiLevel) continue;
            devices.add(realDevice.getSerialNumber());
        }
        return devices;
    }

    public static AndroidDebugBridge initAdb(File sdk, long timeOutMs) {
        AndroidDebugBridge.initIfNeeded((boolean)false);
        File adbPath = FileUtils.getFile((File)sdk, (String[])new String[]{"platform-tools", "adb"});
        AndroidDebugBridge adb = AndroidDebugBridge.createBridge((String)adbPath.getAbsolutePath(), (boolean)false);
        SpoonUtils.waitForAdb(adb, timeOutMs);
        return adb;
    }

    static void createAnimatedGif(List<File> testScreenshots, File animatedGif) throws IOException {
        AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        encoder.start(animatedGif.getAbsolutePath());
        encoder.setDelay(1500);
        encoder.setQuality(1);
        encoder.setRepeat(0);
        encoder.setTransparent(Color.WHITE);
        int width = 0;
        int height = 0;
        for (File testScreenshot : testScreenshots) {
            BufferedImage bufferedImage = ImageIO.read(testScreenshot);
            width = Math.max(bufferedImage.getWidth(), width);
            height = Math.max(bufferedImage.getHeight(), height);
        }
        encoder.setSize(width, height);
        for (File testScreenshot : testScreenshots) {
            encoder.addFrame(ImageIO.read(testScreenshot));
        }
        encoder.finish();
    }

    private static void waitForAdb(AndroidDebugBridge adb, long timeOutMs) {
        long sleepTimeMs = TimeUnit.SECONDS.toMillis(1L);
        while (!adb.hasInitialDeviceList() && timeOutMs > 0L) {
            try {
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            timeOutMs -= sleepTimeMs;
        }
        if (timeOutMs <= 0L && !adb.hasInitialDeviceList()) {
            throw new RuntimeException("Timeout getting device list.", null);
        }
    }

    private SpoonUtils() {
    }
}

