/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon.html;

import com.google.gson.Gson;
import com.squareup.spoon.DeviceDetails;
import com.squareup.spoon.DeviceResult;
import com.squareup.spoon.DeviceTest;
import com.squareup.spoon.DeviceTestResult;
import com.squareup.spoon.SpoonSummary;
import com.squareup.spoon.html.HtmlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class HtmlTv {
    public final String title;
    public final String testDate;
    public final String duration;
    public final String outputJson;

    static HtmlTv from(Gson gson, SpoonSummary summary, File outputPath) {
        String testDate = HtmlUtils.dateToTvString(summary.getStarted());
        String title = summary.getTitle();
        String duration = HtmlUtils.humanReadableDuration(summary.getDuration());
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Map.Entry<String, DeviceResult> result : summary.getResults().entrySet()) {
            devices.add(Device.from(result.getKey(), result.getValue(), outputPath));
        }
        Collections.sort(devices);
        return new HtmlTv(gson, title, testDate, duration, devices);
    }

    HtmlTv(Gson gson, String title, String testDate, String duration, List<Device> devices) {
        this.title = title;
        this.testDate = testDate;
        this.duration = duration;
        this.outputJson = gson.toJson(devices);
    }

    static final class TestResult
    implements Comparable<TestResult> {
        public final String classSimpleName;
        public final String methodPrettyName;
        public final String serial;
        public final String status;
        public final List<HtmlUtils.Screenshot> screenshots;

        static TestResult from(String serial, String className, String name, DeviceTestResult result, File output) {
            String status = HtmlUtils.getStatusCssClass(result);
            ArrayList<HtmlUtils.Screenshot> screenshots = new ArrayList<HtmlUtils.Screenshot>();
            for (File screenshot : result.getScreenshots()) {
                screenshots.add(HtmlUtils.getScreenshot(screenshot, output));
            }
            return new TestResult(className, name, serial, status, screenshots);
        }

        TestResult(String className, String methodPrettyName, String serial, String status, List<HtmlUtils.Screenshot> screenshots) {
            this.classSimpleName = className;
            this.methodPrettyName = methodPrettyName;
            this.serial = serial;
            this.status = status;
            this.screenshots = screenshots;
        }

        @Override
        public int compareTo(TestResult other) {
            return this.methodPrettyName.compareTo(other.methodPrettyName);
        }
    }

    static final class Device
    implements Comparable<Device> {
        public final String serial;
        public final String name;
        public final String details;
        public final List<TestResult> testResults;

        static Device from(String serial, DeviceResult result, File outputPath) {
            ArrayList<TestResult> testResults = new ArrayList<TestResult>();
            for (Map.Entry<DeviceTest, DeviceTestResult> entry : result.getTestResults().entrySet()) {
                if (entry.getValue().getScreenshots().isEmpty()) continue;
                String classSimpleName = HtmlUtils.getClassSimpleName(entry.getKey().getClassName());
                String prettyMethodName = HtmlUtils.prettifyMethodName(entry.getKey().getMethodName());
                testResults.add(TestResult.from(serial, classSimpleName, prettyMethodName, entry.getValue(), outputPath));
            }
            DeviceDetails deviceDetails = result.getDeviceDetails();
            String name = deviceDetails != null ? deviceDetails.getName() : serial;
            String details = HtmlUtils.deviceDetailsToString(deviceDetails);
            return new Device(serial, name, details, testResults);
        }

        Device(String serial, String name, String details, List<TestResult> testResults) {
            this.serial = serial;
            this.name = name;
            this.details = details;
            this.testResults = testResults;
        }

        @Override
        public int compareTo(Device other) {
            if (this.name == null && other.name == null) {
                return this.serial.compareTo(other.serial);
            }
            if (this.name == null) {
                return 1;
            }
            if (other.name == null) {
                return -1;
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name != null ? this.name : this.serial;
        }
    }
}

