/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.logcat.LogCatMessage;
import com.google.common.base.Preconditions;
import com.squareup.spoon.SpoonLogger;
import com.squareup.spoon.misc.StackTrace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DeviceTestResult {
    public static final String SCREENSHOT_SEPARATOR = "_";
    private final Status status;
    private final StackTrace exception;
    private final long duration;
    private final List<File> screenshots;
    private final List<File> files;
    private final File animatedGif;
    private final List<LogCatMessage> log;

    private DeviceTestResult(Status status, StackTrace exception, long duration, List<File> screenshots, File animatedGif, List<LogCatMessage> log, List<File> files) {
        this.status = status;
        this.exception = exception;
        this.duration = duration;
        this.screenshots = Collections.unmodifiableList(new ArrayList<File>(screenshots));
        this.files = Collections.unmodifiableList(new ArrayList<File>(files));
        this.animatedGif = animatedGif;
        this.log = Collections.unmodifiableList(new ArrayList<LogCatMessage>(log));
    }

    public Status getStatus() {
        return this.status;
    }

    public StackTrace getException() {
        return this.exception;
    }

    public long getDuration() {
        return this.duration;
    }

    public List<File> getScreenshots() {
        return this.screenshots;
    }

    public File getAnimatedGif() {
        return this.animatedGif;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<LogCatMessage> getLog() {
        return this.log;
    }

    public static class Builder {
        private final List<File> screenshots = new ArrayList<File>();
        private final List<File> files = new ArrayList<File>();
        private Status status = Status.PASS;
        private StackTrace exception;
        private long start;
        private long duration = -1L;
        private File animatedGif;
        private List<LogCatMessage> log;

        public Builder markTestAsFailed(String message) {
            Preconditions.checkNotNull((Object)message);
            if (this.status != Status.PASS) {
                SpoonLogger.logError("Status was already marked as failed!", new Object[0]);
            }
            this.status = Status.FAIL;
            this.exception = StackTrace.from(message);
            return this;
        }

        public Builder setLog(List<LogCatMessage> log) {
            Preconditions.checkNotNull(log);
            Preconditions.checkArgument((this.log == null ? 1 : 0) != 0, (Object)"Log already added.");
            this.log = log;
            return this;
        }

        public Builder startTest() {
            Preconditions.checkArgument((this.start == 0L ? 1 : 0) != 0, (Object)"Start already called.");
            this.start = System.nanoTime();
            return this;
        }

        public Builder endTest() {
            Preconditions.checkArgument((this.start != 0L ? 1 : 0) != 0, (Object)"Start was not called.");
            if (this.duration != -1L) {
                SpoonLogger.logError("Test was already marked as ended!", new Object[0]);
            }
            this.duration = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start);
            return this;
        }

        public Builder addScreenshot(File screenshot) {
            Preconditions.checkNotNull((Object)screenshot);
            this.screenshots.add(screenshot);
            return this;
        }

        public Builder addFile(File file) {
            Preconditions.checkNotNull((Object)file);
            this.files.add(file);
            return this;
        }

        public Builder setAnimatedGif(File animatedGif) {
            Preconditions.checkNotNull((Object)animatedGif);
            Preconditions.checkArgument((this.animatedGif == null ? 1 : 0) != 0, (Object)"Animated GIF already set.");
            this.animatedGif = animatedGif;
            return this;
        }

        public DeviceTestResult build() {
            if (this.log == null) {
                this.log = Collections.emptyList();
            }
            return new DeviceTestResult(this.status, this.exception, this.duration, this.screenshots, this.animatedGif, this.log, this.files);
        }
    }

    public static enum Status {
        PASS,
        FAIL;

    }
}

