/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.google.common.base.Preconditions;
import com.squareup.spoon.DeviceResult;
import com.squareup.spoon.DeviceTest;
import com.squareup.spoon.DeviceTestResult;
import com.squareup.spoon.SpoonLogger;
import com.squareup.spoon.adapters.TestIdentifierAdapter;
import java.util.HashMap;
import java.util.Map;

final class SpoonTestRunListener
implements ITestRunListener {
    private final DeviceResult.Builder result;
    private final Map<TestIdentifier, DeviceTestResult.Builder> methodResults = new HashMap<TestIdentifier, DeviceTestResult.Builder>();
    private final boolean debug;
    private final TestIdentifierAdapter testIdentifierAdapter;

    SpoonTestRunListener(DeviceResult.Builder result, boolean debug, TestIdentifierAdapter testIdentifierAdapter) {
        Preconditions.checkNotNull((Object)result);
        this.result = result;
        this.debug = debug;
        this.testIdentifierAdapter = testIdentifierAdapter;
    }

    public void testRunStarted(String runName, int testCount) {
        SpoonLogger.logDebug(this.debug, "testCount=%d runName=%s", testCount, runName);
        this.result.startTests();
    }

    public void testStarted(TestIdentifier test) {
        SpoonLogger.logDebug(this.debug, "test=%s", test);
        DeviceTestResult.Builder methodResult = new DeviceTestResult.Builder().startTest();
        this.methodResults.put(this.testIdentifierAdapter.adapt(test), methodResult);
    }

    public void testFailed(TestIdentifier test, String trace) {
        SpoonLogger.logDebug(this.debug, "test=%s", test);
        test = this.testIdentifierAdapter.adapt(test);
        DeviceTestResult.Builder methodResult = this.methodResults.get(test);
        if (methodResult == null) {
            SpoonLogger.logError("unknown test=%s", test);
            methodResult = new DeviceTestResult.Builder();
            this.methodResults.put(test, methodResult);
        }
        SpoonLogger.logDebug(this.debug, "failed %s", trace);
        methodResult.markTestAsFailed(trace);
    }

    public void testAssumptionFailure(TestIdentifier test, String trace) {
        SpoonLogger.logDebug(this.debug, "test=%s", test);
        SpoonLogger.logDebug(this.debug, "assumption failure %s", trace);
    }

    public void testIgnored(TestIdentifier test) {
        SpoonLogger.logDebug(this.debug, "ignored test %s", test);
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        SpoonLogger.logDebug(this.debug, "test=%s", test);
        test = this.testIdentifierAdapter.adapt(test);
        DeviceTestResult.Builder methodResult = this.methodResults.get(test);
        if (methodResult == null) {
            SpoonLogger.logError("unknown test=%s", test);
            methodResult = new DeviceTestResult.Builder().startTest();
            this.methodResults.put(test, methodResult);
        }
        DeviceTestResult.Builder methodResultBuilder = methodResult.endTest();
        this.result.addTestResultBuilder(DeviceTest.from(test), methodResultBuilder);
    }

    public void testRunFailed(String errorMessage) {
        SpoonLogger.logDebug(this.debug, "errorMessage=%s", errorMessage);
        this.result.addException(errorMessage);
    }

    public void testRunStopped(long elapsedTime) {
        SpoonLogger.logDebug(this.debug, "elapsedTime=%d", elapsedTime);
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        SpoonLogger.logDebug(this.debug, "elapsedTime=%d", elapsedTime);
        this.result.endTests();
    }
}

