/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon.misc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StackTrace {
    private static final Pattern HEADER = Pattern.compile("(?:Caused by: )?([^:]+)(?::( .*)?)?");
    private static final Pattern MORE = Pattern.compile("\\.\\.\\. \\d+ more");
    private static final Pattern ELEMENT = Pattern.compile("\\s*at (.*?)\\.([^.(]+)\\((?:([^:]+):(\\d+)|Native Method)\\)");
    private final String className;
    private final String message;
    private final List<Element> elements;
    private final StackTrace cause;

    public static StackTrace from(Throwable exception) {
        Preconditions.checkNotNull((Object)exception);
        StackTrace cause = null;
        Throwable realCause = exception.getCause();
        if (realCause != null && realCause != exception) {
            cause = StackTrace.from(realCause);
        }
        ArrayDeque<Element> elements = new ArrayDeque<Element>();
        for (StackTraceElement element : exception.getStackTrace()) {
            elements.add(Element.from(element));
        }
        String className = exception.getClass().getCanonicalName();
        String message = exception.getMessage();
        return new StackTrace(className, message, elements, cause);
    }

    public static StackTrace from(String exception) {
        Preconditions.checkNotNull((Object)exception);
        String[] parts = exception.replace("\r\n", "\n").split("\n");
        StackTrace last = null;
        ArrayDeque<String> messageParts = new ArrayDeque<String>();
        ArrayDeque<Element> elements = new ArrayDeque<Element>();
        boolean matchingElements = true;
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            Matcher elementMatch = ELEMENT.matcher(part);
            Matcher moreMatch = MORE.matcher(part);
            boolean moreMatches = moreMatch.matches();
            if (elementMatch.matches() || moreMatches) {
                if (!matchingElements) {
                    last = StackTrace.acceptTrace(messageParts, elements, last);
                    elements.clear();
                    messageParts.clear();
                }
                matchingElements = true;
                if (moreMatches) continue;
                String className = elementMatch.group(1);
                String methodName = elementMatch.group(2);
                String fileName = elementMatch.group(3);
                boolean isNative = fileName == null;
                int line = isNative ? 0 : Integer.parseInt(elementMatch.group(4));
                elements.addFirst(new Element(className, fileName, line, methodName, isNative));
                continue;
            }
            matchingElements = false;
            messageParts.addFirst(part);
        }
        return StackTrace.acceptTrace(messageParts, elements, last);
    }

    private static StackTrace acceptTrace(Deque<String> messageParts, Deque<Element> elements, StackTrace last) {
        String message;
        String header = messageParts.removeFirst();
        Matcher headerMatch = HEADER.matcher(header);
        if (!headerMatch.matches()) {
            throw new IllegalStateException("Couldn't match exception header.");
        }
        String exceptionClass = headerMatch.group(1);
        String messagePart = headerMatch.group(2);
        if (!StringUtils.isEmpty((CharSequence)messagePart)) {
            messageParts.addFirst(messagePart.trim());
        }
        if (!messageParts.isEmpty() && StringUtils.isEmpty((CharSequence)messageParts.peekLast())) {
            messageParts.removeLast();
        }
        if ((message = StringUtils.join(messageParts, (String)"\n")).equals("")) {
            message = null;
        }
        return new StackTrace(exceptionClass, message, elements, last);
    }

    public StackTrace(String className, String message, Deque<Element> elements, StackTrace cause) {
        Preconditions.checkNotNull(elements);
        this.className = className;
        this.message = message;
        this.elements = ImmutableList.copyOf(elements.iterator());
        this.cause = cause;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public StackTrace getCause() {
        return this.cause;
    }

    public String toString() {
        if (this.className != null) {
            if (this.message != null) {
                return this.className + ": " + this.message;
            }
            return this.className;
        }
        return this.message;
    }

    public static class Element {
        private final String className;
        private final String fileName;
        private final int line;
        private final String methodName;
        private final boolean isNative;

        static Element from(StackTraceElement e) {
            return new Element(e.getClassName(), e.getFileName(), e.getLineNumber(), e.getMethodName(), e.isNativeMethod());
        }

        public Element(String className, String fileName, int line, String methodName, boolean isNative) {
            this.className = className;
            this.fileName = fileName;
            this.line = line;
            this.methodName = methodName;
            this.isNative = isNative;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLine() {
            return this.line;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public boolean isNative() {
            return this.isNative;
        }

        public String toString() {
            if (this.isNative) {
                return String.format("%s.%s(Native Method)", this.className, this.methodName);
            }
            return String.format("%s.%s(%s:%d)", this.className, this.methodName, this.fileName, this.line);
        }
    }
}

