/*
 * Decompiled with CFR 0.152.
 */
package com.stephenduncanjr.easymock;

import com.stephenduncanjr.easymock.matcher.BeanProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockPropertyUtils {
    private static final List<String> EMPTY = new LinkedList<String>();

    private EasyMockPropertyUtils() {
    }

    public static <T> T propEq(Class<T> inClass, Map<String, ?> properties) {
        EasyMock.reportMatcher((IArgumentMatcher)new BeanProperty(properties));
        return null;
    }

    public static <T> T propEq(Class<T> inClass, Object valuesObject) {
        EasyMock.reportMatcher((IArgumentMatcher)new BeanProperty(EasyMockPropertyUtils.retrieveAndFilterProperties(valuesObject, EMPTY)));
        return null;
    }

    public static <T> T propEq(Class<T> inClass, Object valuesObject, List<String> ignored) {
        EasyMock.reportMatcher((IArgumentMatcher)new BeanProperty(EasyMockPropertyUtils.retrieveAndFilterProperties(valuesObject, ignored)));
        return null;
    }

    public static <T> T propEq(Class<T> inClass, Object valuesObject, String[] ignored) {
        EasyMock.reportMatcher((IArgumentMatcher)new BeanProperty(EasyMockPropertyUtils.retrieveAndFilterProperties(valuesObject, Arrays.asList(ignored))));
        return null;
    }

    public static <T> T propEq(Class<T> inClass, String property, Object value) {
        EasyMock.reportMatcher((IArgumentMatcher)new BeanProperty(property, value));
        return null;
    }

    public static <T> T propEq(T valuesObject) {
        EasyMock.reportMatcher((IArgumentMatcher)new BeanProperty(EasyMockPropertyUtils.retrieveAndFilterProperties(valuesObject, EMPTY)));
        return null;
    }

    public static <T> T propEq(T valuesObject, List<String> ignored) {
        EasyMock.reportMatcher((IArgumentMatcher)new BeanProperty(EasyMockPropertyUtils.retrieveAndFilterProperties(valuesObject, ignored)));
        return null;
    }

    public static <T> T propEq(T valuesObject, String[] ignored) {
        EasyMock.reportMatcher((IArgumentMatcher)new BeanProperty(EasyMockPropertyUtils.retrieveAndFilterProperties(valuesObject, Arrays.asList(ignored))));
        return null;
    }

    @Deprecated
    public static <T> T propertiesEq(Class<T> inClass, Map<String, ?> properties) {
        return EasyMockPropertyUtils.propertiesEq(inClass, properties);
    }

    @Deprecated
    public static <T> T propertyEq(Class<T> inClass, String property, Object value) {
        return EasyMockPropertyUtils.propEq(inClass, property, value);
    }

    private static Map<String, Object> retrieveAndFilterProperties(Object bean, List<String> ignoredProperties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (PropertyDescriptor p : PropertyUtils.getPropertyDescriptors((Object)bean)) {
                Method readMethod;
                if (ignoredProperties.contains(p.getName()) || "class".equals(p.getName()) || (readMethod = p.getReadMethod()) == null) continue;
                map.put(p.getName(), readMethod.invoke(bean, new Object[0]));
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return map;
    }
}

