/*
 * Decompiled with CFR 0.152.
 */
package com.stephenduncanjr.easymock.matcher;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.easymock.IArgumentMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanProperty
implements IArgumentMatcher {
    private final Map<String, ?> expectedProperties;

    public BeanProperty(Map<String, ?> expectedProperties) {
        this.expectedProperties = expectedProperties;
    }

    public BeanProperty(String propertyName, Object expectedPropertyValue) {
        HashMap properties = new HashMap();
        properties.put(propertyName, expectedPropertyValue);
        this.expectedProperties = properties;
    }

    public void appendTo(StringBuffer buffer) {
        buffer.append("propertyEq(");
        for (Map.Entry<String, ?> entry : this.expectedProperties.entrySet()) {
            buffer.append(entry.getKey());
            buffer.append("=");
            buffer.append(entry.getValue());
            buffer.append(", ");
        }
        buffer.replace(buffer.length() - 2, buffer.length(), ")");
    }

    public boolean matches(Object actual) {
        for (Map.Entry<String, ?> entry : this.expectedProperties.entrySet()) {
            try {
                Object actualValue = PropertyUtils.getProperty((Object)actual, (String)entry.getKey());
                if (entry.getValue() == actualValue || entry.getValue().equals(actualValue)) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return true;
    }
}

