/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.cache;

import com.stormpath.sdk.lang.Assert;
import org.springframework.cache.Cache;

public class SpringCache<K, V>
implements com.stormpath.sdk.cache.Cache<K, V> {
    private final Cache springCache;

    public SpringCache(Cache springCache) {
        Assert.notNull((Object)springCache, (String)"spring cache instance cannot be null.");
        this.springCache = springCache;
    }

    public V get(K key) {
        Cache.ValueWrapper vw = this.springCache.get(key);
        if (vw == null) {
            return null;
        }
        return (V)vw.get();
    }

    public V put(K key, V value) {
        Cache.ValueWrapper vw = this.springCache.putIfAbsent(key, value);
        if (vw == null) {
            return null;
        }
        return (V)vw.get();
    }

    public V remove(K key) {
        V v = this.get(key);
        this.springCache.evict(key);
        return v;
    }
}

