/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.config;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyBuilder;
import com.stormpath.sdk.api.ApiKeys;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.cache.Caches;
import com.stormpath.sdk.client.AuthenticationScheme;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.client.ClientBuilder;
import com.stormpath.sdk.client.Clients;
import com.stormpath.sdk.client.Proxy;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.spring.cache.SpringCacheManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

public abstract class AbstractStormpathConfiguration {
    private static final String APP_HREF_ERROR = "A 'stormpath.application.href' property value must be configured if you have more than one application registered in Stormpath.";
    @Autowired(required=false)
    protected org.springframework.cache.CacheManager cacheManager;
    @Value(value="#{ @environment['stormpath.baseUrl'] }")
    protected String baseUrl;
    @Value(value="#{ @environment['stormpath.apiKey.id'] }")
    protected String apiKeyId;
    @Value(value="#{ @environment['stormpath.apiKey.secret'] }")
    protected String apiKeySecret;
    @Value(value="#{ @environment['stormpath.apiKey.file'] }")
    protected Resource apiKeyFile;
    @Value(value="#{ @environment['stormpath.apiKey.fileIdPropertyName'] }")
    protected String apiKeyFileIdPropertyName;
    @Value(value="#{ @environment['stormpath.apiKey.fileSecretPropertyName'] }")
    protected String apiKeyFileSecretPropertyName;
    @Value(value="#{ @environment['stormpath.application.href'] }")
    protected String applicationHref;
    @Value(value="#{ @environment['stormpath.cache.enabled'] ?: true }")
    protected boolean cachingEnabled;
    @Value(value="#{ @environment['stormpath.proxy.host'] }")
    protected String proxyHost;
    @Value(value="#{ @environment['stormpath.proxy.port'] ?: 80 }")
    protected int proxyPort;
    @Value(value="#{ @environment['stormpath.proxy.username'] }")
    protected String proxyUsername;
    @Value(value="#{ @environment['stormpath.proxy.password'] }")
    protected String proxyPassword;
    @Value(value="#{ @environment['stormpath.connectionTimeout'] ?: 0 }")
    protected int connectionTimeout;
    @Value(value="#{ @environment['stormpath.authentication.scheme'] }")
    protected AuthenticationScheme authenticationScheme;

    public ApiKey stormpathClientApiKey() {
        ApiKeyBuilder builder = ApiKeys.builder();
        if (Strings.hasText((String)this.apiKeyFileIdPropertyName)) {
            builder.setIdPropertyName(this.apiKeyFileIdPropertyName);
        }
        if (Strings.hasText((String)this.apiKeyFileSecretPropertyName)) {
            builder.setSecretPropertyName(this.apiKeyFileSecretPropertyName);
        }
        if (this.apiKeyFile != null) {
            try {
                builder.setInputStream(this.apiKeyFile.getInputStream());
            }
            catch (IOException e) {
                String msg = "Unable to acquire specified resource [" + this.apiKeyFile + "]: " + e.getMessage();
                throw new BeanCreationException(msg, (Throwable)e);
            }
        }
        if (Strings.hasText((String)this.apiKeyId)) {
            builder.setId(this.apiKeyId);
        }
        if (Strings.hasText((String)this.apiKeySecret)) {
            builder.setSecret(this.apiKeySecret);
        }
        return builder.build();
    }

    public Application stormpathApplication() {
        Client client = this.stormpathClient();
        if (Strings.hasText((String)this.applicationHref)) {
            return (Application)client.getResource(this.applicationHref, Application.class);
        }
        Application single = null;
        for (Application app : client.getApplications()) {
            if (app.getName().equalsIgnoreCase("Stormpath")) continue;
            if (single != null) {
                throw new IllegalStateException(APP_HREF_ERROR);
            }
            single = app;
        }
        return single;
    }

    public CacheManager stormpathCacheManager() {
        if (!this.cachingEnabled) {
            return Caches.newDisabledCacheManager();
        }
        if (this.cacheManager != null) {
            return new SpringCacheManager(this.cacheManager);
        }
        return Caches.newCacheManager().withDefaultTimeToLive(1L, TimeUnit.HOURS).withDefaultTimeToIdle(1L, TimeUnit.HOURS).build();
    }

    protected Proxy resolveProxy() {
        if (!Strings.hasText((String)this.proxyHost)) {
            return null;
        }
        Proxy proxy = Strings.hasText((String)this.proxyUsername) || Strings.hasText((String)this.proxyPassword) ? new Proxy(this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword) : new Proxy(this.proxyHost, this.proxyPort);
        return proxy;
    }

    public Client stormpathClient() {
        Proxy proxy;
        ClientBuilder builder = Clients.builder().setApiKey(this.stormpathClientApiKey()).setCacheManager(this.stormpathCacheManager());
        if (this.authenticationScheme != null) {
            builder.setAuthenticationScheme(this.authenticationScheme);
        }
        if (Strings.hasText((String)this.baseUrl)) {
            builder.setBaseUrl(this.baseUrl);
        }
        if ((proxy = this.resolveProxy()) != null) {
            builder.setProxy(proxy);
        }
        if (this.connectionTimeout > 0) {
            builder.setConnectionTimeout(this.connectionTimeout);
        }
        return builder.build();
    }
}

