/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.config;

import com.stormpath.sdk.client.Proxy;
import com.stormpath.sdk.lang.Assert;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.StringUtils;

public class ClientProxyFactoryBean
extends AbstractFactoryBean<Proxy> {
    private String host;
    private int port = 80;
    private String username;
    private String password;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Class<?> getObjectType() {
        return Proxy.class;
    }

    protected Proxy createInstance() throws Exception {
        Assert.hasText((String)this.host, (String)"Proxy host must be specified.");
        Assert.isTrue((this.port > 0 && this.port < 65535 ? 1 : 0) != 0, (String)"Proxy port must be greater than zero and less than 65535");
        Proxy proxy = StringUtils.hasText((String)this.username) || StringUtils.hasText((String)this.password) ? new Proxy(this.host, this.port, this.username, this.password) : new Proxy(this.host, this.port);
        return proxy;
    }
}

