/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.context;

import com.stormpath.sdk.lang.Assert;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class CompositeMessageSource
implements MessageSource {
    private static final Logger log = LoggerFactory.getLogger(CompositeMessageSource.class);
    final MessageSource[] messageSources;

    public CompositeMessageSource(MessageSource ... sources) {
        Assert.notEmpty((Object[])sources, (String)"MessageSources array cannot be null or empty.");
        this.messageSources = sources;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        for (MessageSource messageSource : this.messageSources) {
            String value = messageSource.getMessage(code, args, null, locale);
            if (value == null) continue;
            return value;
        }
        return defaultMessage;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        for (MessageSource messageSource : this.messageSources) {
            String value = null;
            try {
                value = messageSource.getMessage(code, args, locale);
            }
            catch (NoSuchMessageException ignored) {
                String msg = "No message found under code '{}' for locale '{}' using MessageSource {}.";
                log.debug(msg, new Object[]{code, locale, messageSource});
            }
            if (value == null) continue;
            return value;
        }
        if (locale != null) {
            throw new NoSuchMessageException(code, locale);
        }
        throw new NoSuchMessageException(code);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        for (MessageSource messageSource : this.messageSources) {
            String value = null;
            try {
                value = messageSource.getMessage(resolvable, locale);
            }
            catch (NoSuchMessageException ignored) {
                String msg = "No message found via resolvable '{}' for locale '{}' using MessageSource {}.";
                log.debug(msg, new Object[]{resolvable, locale, messageSource});
            }
            if (value == null) continue;
            return value;
        }
        String[] codes = resolvable.getCodes();
        if (codes == null) {
            codes = new String[]{};
        }
        throw new NoSuchMessageException(codes.length > 0 ? codes[codes.length - 1] : null, locale);
    }
}

