/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.cql;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.config.ICassandraDeepJobConfig;
import com.stratio.deep.cassandra.cql.CassandraClientProvider;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.rdd.DeepTokenRange;
import com.stratio.deep.commons.utils.Pair;
import com.stratio.deep.commons.utils.Utils;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;

public class RangeUtils {
    private RangeUtils() {
    }

    static Map<String, Iterable<Comparable>> fetchTokens(String query, Pair<Session, String> sessionWithHost, IPartitioner partitioner) {
        ResultSet rSet = ((Session)sessionWithHost.left).execute(query);
        AbstractType tkValidator = partitioner.getTokenValidator();
        HashMap tokens = Maps.newHashMap();
        Iterable pairs = Iterables.transform((Iterable)rSet.all(), (Function)new FetchTokensRowPairFunction(sessionWithHost, tkValidator));
        for (Pair pair : pairs) {
            tokens.put(pair.left, pair.right);
        }
        return tokens;
    }

    static List<DeepTokenRange> mergeTokenRanges(Map<String, Iterable<Comparable>> tokens, Session session, IPartitioner p) {
        List allRanges = Ordering.natural().sortedCopy(Iterables.concat(tokens.values()));
        Comparable maxValue = (Comparable)Ordering.natural().max((Iterable)allRanges);
        Comparable minValue = (Comparable)p.minValue(maxValue.getClass()).getToken().token;
        MergeTokenRangesFunction map = new MergeTokenRangesFunction(maxValue, minValue, session, p, allRanges);
        Iterable concatenated = Iterables.concat((Iterable)Iterables.transform((Iterable)allRanges, (Function)map));
        HashSet dedup = Sets.newHashSet((Iterable)concatenated);
        return Ordering.natural().sortedCopy((Iterable)dedup);
    }

    private static List<String> initReplicas(Comparable token, Session session, IPartitioner partitioner) {
        AbstractType tkValidator = partitioner.getTokenValidator();
        Metadata metadata = session.getCluster().getMetadata();
        Set replicas = metadata.getReplicas(Utils.quote((String)session.getLoggedKeyspace()), ByteBuffer.wrap(token.toString().getBytes()));
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)replicas, (Function)new Function<Host, String>(){

            @Nullable
            public String apply(@Nullable Host input) {
                assert (input != null);
                return input.getAddress().getHostName();
            }
        }));
    }

    public static List<DeepTokenRange> getSplits(CassandraDeepJobConfig config) {
        HashMap<String, Iterable<Comparable>> tokens = new HashMap<String, Iterable<Comparable>>();
        IPartitioner p = RangeUtils.getPartitioner(config);
        Pair<Session, String> sessionWithHost = CassandraClientProvider.getSession(config.getHost(), config, false);
        String queryLocal = "select tokens from system.local";
        tokens.putAll(RangeUtils.fetchTokens(queryLocal, sessionWithHost, p));
        String queryPeers = "select peer, tokens from system.peers";
        tokens.putAll(RangeUtils.fetchTokens(queryPeers, sessionWithHost, p));
        List<DeepTokenRange> merged = RangeUtils.mergeTokenRanges(tokens, (Session)sessionWithHost.left, p);
        return RangeUtils.splitRanges(merged, p, config.getBisectFactor());
    }

    private static List<DeepTokenRange> splitRanges(List<DeepTokenRange> ranges, final IPartitioner p, final int bisectFactor) {
        if (bisectFactor == 1) {
            return ranges;
        }
        Iterable bisectedRanges = Iterables.concat((Iterable)Iterables.transform(ranges, (Function)new Function<DeepTokenRange, List<DeepTokenRange>>(){

            @Nullable
            public List<DeepTokenRange> apply(@Nullable DeepTokenRange input) {
                ArrayList<DeepTokenRange> splittedRanges = new ArrayList<DeepTokenRange>();
                RangeUtils.bisectTokeRange(input, p, bisectFactor, splittedRanges);
                return splittedRanges;
            }
        }));
        return Lists.newArrayList((Iterable)bisectedRanges);
    }

    private static void bisectTokeRange(DeepTokenRange range, IPartitioner partitioner, int bisectFactor, List<DeepTokenRange> accumulator) {
        AbstractType tkValidator = partitioner.getTokenValidator();
        Token leftToken = partitioner.getTokenFactory().fromByteArray(tkValidator.decompose(range.getStartToken()));
        Token rightToken = partitioner.getTokenFactory().fromByteArray(tkValidator.decompose(range.getEndToken()));
        Token midToken = partitioner.midpoint(leftToken, rightToken);
        Comparable midpoint = (Comparable)tkValidator.compose(tkValidator.fromString(midToken.toString()));
        DeepTokenRange left = new DeepTokenRange(range.getStartToken(), (Object)midpoint, range.getReplicas());
        DeepTokenRange right = new DeepTokenRange((Object)midpoint, range.getEndToken(), range.getReplicas());
        if (bisectFactor / 2 <= 1) {
            accumulator.add(left);
            accumulator.add(right);
        } else {
            RangeUtils.bisectTokeRange(left, partitioner, bisectFactor / 2, accumulator);
            RangeUtils.bisectTokeRange(right, partitioner, bisectFactor / 2, accumulator);
        }
    }

    public static IPartitioner getPartitioner(ICassandraDeepJobConfig config) {
        try {
            return (IPartitioner)Class.forName(config.getPartitionerClassName()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new DeepGenericException((Throwable)e);
        }
    }

    public static List<DeepTokenRange> getSplitsBySize(CassandraDeepJobConfig config) {
        IPartitioner p = RangeUtils.getPartitioner(config);
        AbstractType tokenValidator = p.getTokenValidator();
        Pair<Session, String> sessionWithHost = CassandraClientProvider.getSession(config.getHost(), config, false);
        String query = "CALCULATE SPLITS FROM " + config.getKeyspace() + "." + config.getTable() + " ESTIMATING " + config.getSplitSize();
        ResultSet rSet = ((Session)sessionWithHost.left).execute(query);
        ArrayList<DeepTokenRange> tokens = new ArrayList<DeepTokenRange>();
        for (Row row : rSet.all()) {
            Comparable startToken = (Comparable)tokenValidator.compose(row.getBytesUnsafe("start_token"));
            Comparable endToken = (Comparable)tokenValidator.compose(row.getBytesUnsafe("end_token"));
            ArrayList<String> replicas = new ArrayList<String>();
            for (InetAddress addres : row.getList("preferred_locations", InetAddress.class)) {
                replicas.add(addres.getHostName());
            }
            tokens.add(new DeepTokenRange((Object)startToken, (Object)endToken, replicas));
        }
        return tokens;
    }

    private static class MergeTokenRangesFunction
    implements Function<Comparable, Set<DeepTokenRange>> {
        private final Comparable maxValue;
        private final Comparable minValue;
        private final Session session;
        private final IPartitioner partitioner;
        private final Iterable<Comparable> allRanges;

        public MergeTokenRangesFunction(Comparable maxValue, Comparable minValue, Session session, IPartitioner partitioner, Iterable<Comparable> allRanges) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.session = session;
            this.partitioner = partitioner;
            this.allRanges = allRanges;
        }

        public Set<DeepTokenRange> apply(final Comparable elem) {
            Comparable nextValue;
            Comparable currValue = elem;
            HashSet<DeepTokenRange> result = new HashSet<DeepTokenRange>();
            if (currValue.equals(this.maxValue)) {
                result.add(new DeepTokenRange((Object)currValue, (Object)this.minValue, RangeUtils.initReplicas(currValue, this.session, this.partitioner)));
                currValue = this.minValue;
                nextValue = (Comparable)Iterables.find(this.allRanges, (Predicate)new Predicate<Comparable>(){

                    public boolean apply(@Nullable Comparable input) {
                        assert (input != null);
                        return input.compareTo(MergeTokenRangesFunction.this.minValue) > 0;
                    }
                });
            } else {
                int nextIdx = 1 + Iterables.indexOf(this.allRanges, (Predicate)new Predicate<Comparable>(){

                    public boolean apply(@Nullable Comparable input) {
                        assert (input != null);
                        return input.equals(elem);
                    }
                });
                nextValue = (Comparable)Iterables.get(this.allRanges, (int)nextIdx);
            }
            result.add(new DeepTokenRange((Object)currValue, (Object)nextValue, RangeUtils.initReplicas(currValue, this.session, this.partitioner)));
            return result;
        }
    }

    private static class FetchTokensRowPairFunction
    implements Function<Row, Pair<String, Iterable<Comparable>>> {
        private final Pair<Session, String> sessionWithHost;
        private final AbstractType tkValidator;

        public FetchTokensRowPairFunction(Pair<Session, String> sessionWithHost, AbstractType tkValidator) {
            this.sessionWithHost = sessionWithHost;
            this.tkValidator = tkValidator;
        }

        @Nullable
        public Pair<String, Iterable<Comparable>> apply(@Nullable Row row) {
            InetAddress host;
            assert (row != null);
            try {
                host = row.getInet("peer");
            }
            catch (IllegalArgumentException e) {
                host = Utils.inetAddressFromLocation((String)((String)this.sessionWithHost.right));
            }
            Iterable sortedTokens = Iterables.transform((Iterable)row.getSet("tokens", String.class), (Function)new Function<String, Comparable>(){

                @Nullable
                public Comparable apply(@Nullable String token) {
                    return (Comparable)FetchTokensRowPairFunction.this.tkValidator.compose(FetchTokensRowPairFunction.this.tkValidator.fromString(token));
                }
            });
            return Pair.create((Object)host.getHostName(), (Object)sortedTokens);
        }
    }
}

