/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.extractor;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.config.EntityDeepJobConfig;
import com.stratio.deep.cassandra.extractor.CassandraExtractor;
import com.stratio.deep.cassandra.functions.DeepType2TupleFunction;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.exception.DeepNoSuchFieldException;
import com.stratio.deep.commons.utils.Pair;
import com.stratio.deep.commons.utils.Utils;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraEntityExtractor<T extends IDeepType>
extends CassandraExtractor<T, EntityDeepJobConfig<T>> {
    private static final long serialVersionUID = -3208994171892747470L;
    private static final Logger LOG = LoggerFactory.getLogger(CassandraEntityExtractor.class);

    public CassandraEntityExtractor(Class<T> t) {
        this.cassandraJobConfig = new EntityDeepJobConfig<T>(t);
        this.transformer = new DeepType2TupleFunction();
    }

    @Override
    public T transformElement(Pair<Map<String, ByteBuffer>, Map<String, ByteBuffer>> elem, CassandraDeepJobConfig<T> config) {
        Cell metadata;
        Map<String, Cell> columnDefinitions = config.columnDefinitions();
        Class entityClass = config.getEntityClass();
        EntityDeepJobConfig edjc = (EntityDeepJobConfig)config;
        IDeepType instance = Utils.newTypeInstance((Class)entityClass);
        for (Map.Entry entry : ((Map)elem.left).entrySet()) {
            metadata = columnDefinitions.get(entry.getKey());
            edjc.setInstancePropertyFromDbName(instance, (String)entry.getKey(), ((DataType)metadata.getValue()).deserialize((ByteBuffer)entry.getValue(), ProtocolVersion.V2));
        }
        for (Map.Entry entry : ((Map)elem.right).entrySet()) {
            if (entry.getValue() == null) continue;
            metadata = columnDefinitions.get(entry.getKey());
            try {
                edjc.setInstancePropertyFromDbName(instance, (String)entry.getKey(), ((DataType)metadata.getValue()).deserialize((ByteBuffer)entry.getValue(), ProtocolVersion.V2));
            }
            catch (DeepNoSuchFieldException e) {
                LOG.error(e.getMessage());
            }
        }
        return (T)instance;
    }

    @Override
    public Class getConfigClass() {
        return EntityDeepJobConfig.class;
    }
}

