/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.extractor;

import com.datastax.driver.core.ColumnMetadata;
import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.config.ICassandraDeepJobConfig;
import com.stratio.deep.cassandra.cql.DeepCqlRecordWriter;
import com.stratio.deep.cassandra.cql.DeepRecordReader;
import com.stratio.deep.cassandra.cql.RangeUtils;
import com.stratio.deep.cassandra.querybuilder.CassandraUpdateQueryBuilder;
import com.stratio.deep.cassandra.querybuilder.DefaultQueryBuilder;
import com.stratio.deep.cassandra.thrift.ThriftRangeUtils;
import com.stratio.deep.cassandra.util.CassandraUtils;
import com.stratio.deep.commons.config.BaseConfig;
import com.stratio.deep.commons.config.DeepJobConfig;
import com.stratio.deep.commons.config.ExtractorConfig;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.functions.AbstractSerializableFunction;
import com.stratio.deep.commons.impl.DeepPartition;
import com.stratio.deep.commons.querybuilder.UpdateQueryBuilder;
import com.stratio.deep.commons.rdd.DeepTokenRange;
import com.stratio.deep.commons.rdd.IDeepRecordReader;
import com.stratio.deep.commons.rdd.IExtractor;
import com.stratio.deep.commons.utils.Pair;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.spark.Partition;
import scala.Tuple2;

public abstract class CassandraExtractor<T, S extends BaseConfig<T>>
implements IExtractor<T, S> {
    protected transient IDeepRecordReader<Pair<Map<String, ByteBuffer>, Map<String, ByteBuffer>>> recordReader;
    protected transient DeepCqlRecordWriter writer;
    protected CassandraDeepJobConfig<T> cassandraJobConfig;
    protected transient AbstractSerializableFunction transformer;

    public boolean hasNext() {
        return this.recordReader.hasNext();
    }

    public T next() {
        return this.transformElement((Pair<Map<String, ByteBuffer>, Map<String, ByteBuffer>>)((Pair)this.recordReader.next()), this.cassandraJobConfig);
    }

    public void close() {
        if (this.recordReader != null) {
            this.recordReader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void initIterator(Partition dp, S config) {
        if (config instanceof ExtractorConfig) {
            this.initWithExtractorConfig((ExtractorConfig)config);
        } else {
            this.cassandraJobConfig = (CassandraDeepJobConfig)((DeepJobConfig)config).initialize();
        }
        this.recordReader = this.initRecordReader((DeepPartition)dp, this.cassandraJobConfig);
    }

    private ICassandraDeepJobConfig<T> initWithExtractorConfig(ExtractorConfig<T> config) {
        int id = config.getRddId();
        this.cassandraJobConfig.setRddId(id);
        return (ICassandraDeepJobConfig)this.cassandraJobConfig.initialize(config);
    }

    public abstract T transformElement(Pair<Map<String, ByteBuffer>, Map<String, ByteBuffer>> var1, CassandraDeepJobConfig<T> var2);

    public abstract Class getConfigClass();

    public Partition[] getPartitions(S config) {
        if (config instanceof ExtractorConfig) {
            this.initWithExtractorConfig((ExtractorConfig)config);
        } else {
            this.cassandraJobConfig = (CassandraDeepJobConfig)config;
        }
        List<Object> underlyingInputSplits = null;
        if (CassandraUtils.isFilterdByKey(this.cassandraJobConfig.getFilters(), ((ColumnMetadata)this.cassandraJobConfig.fetchTableMetadata().getPartitionKey().get(0)).getName())) {
            underlyingInputSplits = new ArrayList<DeepTokenRange>();
            underlyingInputSplits.add(new DeepTokenRange((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE, this.cassandraJobConfig.getHostList()));
        } else {
            underlyingInputSplits = this.cassandraJobConfig.isBisectModeSet() ? RangeUtils.getSplits(this.cassandraJobConfig) : ThriftRangeUtils.build(this.cassandraJobConfig).getSplits();
        }
        DeepPartition[] partitions = new DeepPartition[underlyingInputSplits.size()];
        int i = 0;
        for (DeepTokenRange deepTokenRange : underlyingInputSplits) {
            partitions[i] = new DeepPartition(this.cassandraJobConfig.getRddId(), i, deepTokenRange);
            ++i;
        }
        return partitions;
    }

    public List<String> getPreferredLocations(Partition tokenRange) {
        return ((DeepPartition)tokenRange).splitWrapper().getReplicas();
    }

    private IDeepRecordReader initRecordReader(DeepPartition dp, CassandraDeepJobConfig<T> config) {
        DeepRecordReader recordReader = new DeepRecordReader(config, dp.splitWrapper());
        return recordReader;
    }

    public void initSave(S config, T first, UpdateQueryBuilder queryBuilder) {
        if (config instanceof ExtractorConfig) {
            this.cassandraJobConfig = (CassandraDeepJobConfig)this.cassandraJobConfig.initialize((ExtractorConfig)config);
        } else if (config instanceof CassandraDeepJobConfig) {
            this.cassandraJobConfig = (CassandraDeepJobConfig)config;
        }
        this.cassandraJobConfig.createOutputTableIfNeeded((Tuple2<Cells, Cells>)((Tuple2)this.transformer.apply(first)));
        if (queryBuilder == null) {
            queryBuilder = new DefaultQueryBuilder();
        }
        queryBuilder.setCatalogName(this.cassandraJobConfig.getCatalog());
        queryBuilder.setTableName(this.cassandraJobConfig.getTable());
        this.writer = new DeepCqlRecordWriter(this.cassandraJobConfig, (CassandraUpdateQueryBuilder)queryBuilder);
    }

    public void saveRDD(T t) {
        Tuple2 tuple = (Tuple2)this.transformer.apply(t);
        this.writer.write((Cells)tuple._1(), (Cells)tuple._2());
    }
}

