/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.util;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.config.ICassandraDeepJobConfig;
import com.stratio.deep.cassandra.config.OperatorCassandra;
import com.stratio.deep.cassandra.cql.DeepCqlRecordWriter;
import com.stratio.deep.cassandra.querybuilder.DefaultQueryBuilder;
import com.stratio.deep.cassandra.util.AnnotationUtils;
import com.stratio.deep.commons.annotations.DeepField;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.filter.Filter;
import com.stratio.deep.commons.filter.FilterType;
import com.stratio.deep.commons.functions.AbstractSerializableFunction2;
import com.stratio.deep.commons.rdd.DeepTokenRange;
import com.stratio.deep.commons.utils.Pair;
import com.stratio.deep.commons.utils.Utils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.dht.Token;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class CassandraUtils {
    CassandraUtils() {
    }

    public static <W> void doCql3SaveToCassandra(RDD<W> rdd, ICassandraDeepJobConfig<W> writeConfig, Function1<W, Tuple2<Cells, Cells>> transformer) {
        List<Tuple2> split;
        if (!writeConfig.getIsWriteConfig().booleanValue()) {
            throw new IllegalArgumentException("Provided configuration object is not suitable for writing");
        }
        Tuple2 tuple = new Tuple2(null, null);
        RDD mappedRDD = rdd.map(transformer, ClassTag$.MODULE$.apply(tuple.getClass()));
        ((CassandraDeepJobConfig)writeConfig).createOutputTableIfNeeded((Tuple2<Cells, Cells>)((Tuple2)mappedRDD.first()));
        int pageSize = writeConfig.getBatchSize();
        int offset = 0;
        List<Tuple2> elements = Arrays.asList((Tuple2[])mappedRDD.collect());
        do {
            split = elements.subList(pageSize * offset++, Math.min(pageSize * offset, elements.size()));
            Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
            for (Tuple2 t : split) {
                Tuple2 bindVars = Utils.prepareTuple4CqlDriver((Tuple2)t);
                Insert insert = QueryBuilder.insertInto((String)Utils.quote((String)writeConfig.getKeyspace()), (String)Utils.quote((String)writeConfig.getTable())).values((String[])bindVars._1(), (Object[])bindVars._2());
                batch.add((RegularStatement)insert);
            }
            writeConfig.getSession().execute((Statement)batch);
        } while (!split.isEmpty() && split.size() == pageSize);
    }

    public static <W> void doSaveToCassandra(RDD<W> rdd, final ICassandraDeepJobConfig<W> writeConfig, Function1<W, Tuple2<Cells, Cells>> transformer) {
        if (!writeConfig.getIsWriteConfig().booleanValue()) {
            throw new IllegalArgumentException("Provided configuration object is not suitable for writing");
        }
        Tuple2 tuple = new Tuple2(null, null);
        RDD mappedRDD = rdd.map(transformer, ClassTag$.MODULE$.apply(tuple.getClass()));
        ((CassandraDeepJobConfig)writeConfig).createOutputTableIfNeeded((Tuple2<Cells, Cells>)((Tuple2)mappedRDD.first()));
        ClassTag uClassTag = ClassTag$.MODULE$.apply(Integer.class);
        mappedRDD.context().runJob(mappedRDD, (Function2)new AbstractSerializableFunction2<TaskContext, Iterator<Tuple2<Cells, Cells>>, Integer>(){

            public Integer apply(TaskContext context, Iterator<Tuple2<Cells, Cells>> rows) {
                try (DeepCqlRecordWriter writer = new DeepCqlRecordWriter(writeConfig, new DefaultQueryBuilder());){
                    while (rows.hasNext()) {
                        Tuple2 row = (Tuple2)rows.next();
                        writer.write((Cells)row._1(), (Cells)row._2());
                    }
                }
                return null;
            }
        }, uClassTag);
    }

    public static <T> AbstractType<?> marshallerInstance(T obj) {
        Object abstractType = null;
        if (obj != null) {
            abstractType = AnnotationUtils.MAP_JAVA_TYPE_TO_ABSTRACT_TYPE.get(obj.getClass());
            if (obj instanceof UUID) {
                UUID uuid = (UUID)obj;
                abstractType = uuid.version() == 1 ? TimeUUIDType.instance : UUIDType.instance;
            }
            if (abstractType == null) {
                Set set;
                if (List.class.isAssignableFrom(obj.getClass())) {
                    List list = (List)obj;
                    if (!list.isEmpty()) {
                        abstractType = ListType.getInstance(CassandraUtils.marshallerInstance(list.get(0)));
                    }
                } else if (Set.class.isAssignableFrom(obj.getClass())) {
                    set = (Set)obj;
                    if (!set.isEmpty()) {
                        java.util.Iterator i = set.iterator();
                        Object o = i.next();
                        abstractType = SetType.getInstance(CassandraUtils.marshallerInstance(o));
                    }
                } else if (Map.class.isAssignableFrom(obj.getClass()) && !(set = ((Map)obj).keySet()).isEmpty()) {
                    java.util.Iterator i = set.iterator();
                    Object o = i.next();
                    abstractType = MapType.getInstance(CassandraUtils.marshallerInstance(o), CassandraUtils.marshallerInstance(((Map)obj).get(o)));
                }
            }
        }
        if (abstractType == null) {
            throw new DeepGenericException("parameter class " + obj.getClass().getCanonicalName() + " does not have a" + " Cassandra marshaller");
        }
        return abstractType;
    }

    public static String updateQueryGenerator(Cells keys, Cells values, String outputKeyspace, String outputColumnFamily) {
        StringBuilder sb = new StringBuilder("UPDATE ").append(outputKeyspace).append(".").append(outputColumnFamily).append(" SET ");
        int k = 0;
        StringBuilder keyClause = new StringBuilder(" WHERE ");
        for (Cell cell : keys.getCells()) {
            if (!cell.isKey().booleanValue() && !cell.isClusterKey().booleanValue()) continue;
            if (k > 0) {
                keyClause.append(" AND ");
            }
            keyClause.append(String.format("%s = ?", Utils.quote((String)cell.getCellName())));
            ++k;
        }
        k = 0;
        for (Cell cell : values.getCells()) {
            if (k > 0) {
                sb.append(", ");
            }
            sb.append(String.format("%s = ?", Utils.quote((String)cell.getCellName())));
            ++k;
        }
        sb.append((CharSequence)keyClause).append(";");
        return sb.toString();
    }

    public static String createTableQueryGenerator(Cells keys, Cells values, String outputKeyspace, String outputColumnFamily) {
        if (keys == null || StringUtils.isEmpty((String)outputKeyspace) || StringUtils.isEmpty((String)outputColumnFamily)) {
            throw new DeepGenericException("keys, outputKeyspace and outputColumnFamily cannot be null");
        }
        StringBuilder sb = new StringBuilder("CREATE TABLE ").append(outputKeyspace).append(".").append(outputColumnFamily).append(" (");
        ArrayList<String> partitionKey = new ArrayList<String>();
        ArrayList<String> clusterKey = new ArrayList<String>();
        boolean isFirstField = true;
        for (Cell key : keys) {
            String cellName = Utils.quote((String)key.getCellName());
            if (!isFirstField) {
                sb.append(", ");
            }
            sb.append(cellName).append(" ").append(CassandraUtils.marshallerInstance(key.getValue()).asCQL3Type().toString());
            if (key.isKey().booleanValue()) {
                partitionKey.add(cellName);
            } else if (key.isClusterKey().booleanValue()) {
                clusterKey.add(cellName);
            }
            isFirstField = false;
        }
        if (values != null) {
            for (Cell cell : values) {
                sb.append(", ");
                if (cell.getValue() == null) continue;
                sb.append(Utils.quote((String)cell.getCellName())).append(" ").append(CassandraUtils.marshallerInstance(cell.getValue()).asCQL3Type().toString());
            }
        }
        StringBuilder partitionKeyToken = new StringBuilder("(");
        isFirstField = true;
        for (String s : partitionKey) {
            if (!isFirstField) {
                partitionKeyToken.append(", ");
            }
            partitionKeyToken.append(s);
            isFirstField = false;
        }
        partitionKeyToken.append(")");
        StringBuilder clusterKeyToken = new StringBuilder("");
        isFirstField = true;
        for (String s : clusterKey) {
            if (!isFirstField) {
                clusterKeyToken.append(", ");
            }
            clusterKeyToken.append(s);
            isFirstField = false;
        }
        StringBuilder keyPart = new StringBuilder(", PRIMARY KEY ");
        if (!clusterKey.isEmpty()) {
            keyPart.append("(");
        }
        keyPart.append((CharSequence)partitionKeyToken);
        if (!clusterKey.isEmpty()) {
            keyPart.append(", ");
            keyPart.append((CharSequence)clusterKeyToken);
            keyPart.append(")");
        }
        sb.append((CharSequence)keyPart).append(");");
        return sb.toString();
    }

    public static <T extends IDeepType> Tuple2<Cells, Cells> deepType2tuple(T e) {
        Pair fields = com.stratio.deep.commons.utils.AnnotationUtils.filterKeyFields(e.getClass());
        Field[] keyFields = (Field[])fields.left;
        Field[] otherFields = (Field[])fields.right;
        Cells keys = new Cells(e.getClass().getName());
        Cells values = new Cells(e.getClass().getName());
        for (Field keyField : keyFields) {
            keys.add(CassandraUtils.createFromEntity(e, keyField));
        }
        for (Field valueField : otherFields) {
            values.add(CassandraUtils.createFromEntity(e, valueField));
        }
        return new Tuple2((Object)keys, (Object)values);
    }

    public static String additionalFilterGenerator(Map<String, Serializable> additionalFilters, Filter[] filters, String luceneIndex) {
        String value;
        StringBuilder sb = new StringBuilder("");
        if (!MapUtils.isEmpty(additionalFilters)) {
            for (Map.Entry<String, Serializable> entry : additionalFilters.entrySet()) {
                if (entry.getValue() == null) continue;
                value = entry.getValue().toString();
                if (entry.getValue() instanceof String) {
                    value = Utils.singleQuote((String)value.trim());
                }
                sb.append(" AND ").append(Utils.quote((String)entry.getKey())).append(" = ").append(value);
            }
        }
        if (filters != null) {
            block7: for (int i = 0; i < filters.length; ++i) {
                FilterType filterType = filters[i].getFilterType();
                value = filters[i].getValue().toString();
                if (filters[i].getValue() instanceof String) {
                    value = Utils.singleQuote((String)value.trim());
                }
                switch (filterType) {
                    case IN: {
                        List inValues = (List)((Object)filters[i].getValue());
                        sb.append(" AND ").append(Utils.quote((String)filters[i].getField())).append(" IN ").append("(");
                        if (!inValues.isEmpty()) {
                            if (inValues.get(0) instanceof String) {
                                sb.append("'").append(StringUtils.join((Collection)((List)((Object)filters[i].getValue())), (String)"','")).append("'");
                            } else {
                                sb.append(StringUtils.join((Collection)((List)((Object)filters[i].getValue())), (String)","));
                            }
                        }
                        sb.append(")");
                        continue block7;
                    }
                    case BETWEEN: {
                        continue block7;
                    }
                    case MATCH: {
                        sb.append(" AND ").append(luceneIndex).append(" = '");
                        sb.append(CassandraUtils.getLuceneWhereClause(filters[i]));
                        sb.append("'");
                        continue block7;
                    }
                    case NEQ: {
                        sb.append(" AND ").append(Utils.quote((String)filters[i].getField())).append(" ").append(" < ").append(" ").append(value).append(" AND ").append(Utils.quote((String)filters[i].getField())).append(" ").append(" > ").append(" ").append(value);
                        continue block7;
                    }
                    default: {
                        sb.append(" AND ").append(Utils.quote((String)filters[i].getField())).append(" ").append(OperatorCassandra.getOperatorCassandra(filters[i].getFilterType()).getOperator()).append(" ").append(value);
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String additionalFilterGenerator(Map<String, Serializable> additionalFilters) {
        if (MapUtils.isEmpty(additionalFilters)) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        for (Map.Entry<String, Serializable> entry : additionalFilters.entrySet()) {
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            if (entry.getValue() instanceof String) {
                value = Utils.singleQuote((String)value.trim());
            }
            sb.append(" AND ").append(Utils.quote((String)entry.getKey())).append(" = ").append(value);
        }
        return sb.toString();
    }

    private static String getLuceneWhereClause(Filter filter) {
        StringBuilder sb = new StringBuilder("{filter:{type:\"boolean\",must:[");
        String column = filter.getField();
        String value = (String)((Object)filter.getValue());
        String[] processedQuery = CassandraUtils.processLuceneQueryType(value);
        sb.append("{type:\"");
        sb.append(processedQuery[0]);
        sb.append("\",field:\"");
        sb.append(column);
        sb.append("\",value:\"");
        sb.append(processedQuery[1]);
        sb.append("\"},");
        sb.replace(sb.length() - 1, sb.length(), "");
        sb.append("]}}");
        String result = sb.toString();
        return result;
    }

    private static String[] processLuceneQueryType(String query) {
        String[] result = new String[]{"", ""};
        Pattern escaped = Pattern.compile(".*\\\\\\*.*|.*\\\\\\?.*|.*\\\\\\[.*|.*\\\\\\].*");
        Pattern wildcard = Pattern.compile(".*\\*.*|.*\\?.*");
        Pattern regex = Pattern.compile(".*\\].*|.*\\[.*");
        Pattern fuzzy = Pattern.compile(".*~\\d+");
        if (escaped.matcher(query).matches()) {
            result[0] = "match";
            result[1] = query.replace("\\*", "*").replace("\\?", "?").replace("\\]", "]").replace("\\[", "[");
        } else if (regex.matcher(query).matches()) {
            result[0] = "regex";
            result[1] = query;
        } else if (fuzzy.matcher(query).matches()) {
            result[0] = "fuzzy";
            result[1] = query;
        } else if (wildcard.matcher(query).matches()) {
            result[0] = "wildcard";
            result[1] = query;
        } else {
            result[0] = "match";
            result[1] = query;
        }
        result[1] = result[1].replaceAll("^'", "").replaceAll("'$", "");
        return result;
    }

    public static ByteBuffer getPartitionKey(Cells cells, AbstractType<?> keyValidator, int numberOfKeys) {
        ByteBuffer partitionKey;
        if (keyValidator instanceof CompositeType) {
            ByteBuffer[] keys = new ByteBuffer[numberOfKeys];
            for (int i = 0; i < cells.size(); ++i) {
                Cell c = cells.getCellByIdx(i);
                if (!c.isKey().booleanValue()) continue;
                keys[i] = DataType.serializeValue((Object)c.getValue(), (ProtocolVersion)ProtocolVersion.V2);
            }
            partitionKey = CompositeType.build((ByteBuffer[])keys);
        } else {
            Cell cell = cells.getCellByIdx(0);
            partitionKey = DataType.serializeValue((Object)cell.getValue(), (ProtocolVersion)ProtocolVersion.V2);
        }
        return partitionKey;
    }

    public static Cell createFromByteBuffer(Cell metadata, ByteBuffer cellValue) {
        String cellName = metadata.getCellName();
        boolean isClusterKey = metadata.isClusterKey();
        boolean isKey = metadata.isKey();
        Object o = null;
        if (cellValue != null) {
            o = ((DataType)metadata.getValue()).deserialize(cellValue, ProtocolVersion.V2);
        }
        return Cell.create((String)cellName, (Object)o, (Boolean)isKey, (Boolean)isClusterKey);
    }

    public static Cell createFromEntity(IDeepType e, Field field) {
        DeepField annotation = field.getAnnotation(DeepField.class);
        String cellName = com.stratio.deep.commons.utils.AnnotationUtils.deepFieldName((Field)field);
        Serializable cellValue = com.stratio.deep.commons.utils.AnnotationUtils.getBeanFieldValue((IDeepType)e, (Field)field);
        boolean isClusterKey = annotation.isPartOfClusterKey();
        boolean isKey = annotation.isPartOfPartitionKey();
        return Cell.create((String)cellName, (Object)cellValue, (Boolean)isKey, (Boolean)isClusterKey);
    }

    public static boolean isTokenIncludedInRange(DeepTokenRange deepTokenRange, Token<Comparable> token) {
        boolean isIncluded = false;
        if (((Comparable)deepTokenRange.getStartTokenAsComparable()).compareTo(deepTokenRange.getEndTokenAsComparable()) <= 0) {
            boolean bl = isIncluded = ((Comparable)token.token).compareTo(deepTokenRange.getStartTokenAsComparable()) > 0;
            if (isIncluded) {
                isIncluded = ((Comparable)token.token).compareTo(deepTokenRange.getEndTokenAsComparable()) <= 0;
            }
        } else {
            boolean bl = isIncluded = ((Comparable)token.token).compareTo(deepTokenRange.getStartTokenAsComparable()) > 0;
            if (!isIncluded) {
                isIncluded = ((Comparable)token.token).compareTo(deepTokenRange.getEndTokenAsComparable()) <= 0;
            }
        }
        return isIncluded;
    }

    public static boolean isFilterdByKey(Filter[] filters, String partitionKeyString) {
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                if (!Utils.quote((String)filters[i].getField()).equalsIgnoreCase(Utils.quote((String)partitionKeyString))) continue;
                return true;
            }
        }
        return false;
    }
}

