/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.config;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.stratio.deep.cassandra.config.ICassandraDeepJobConfig;
import com.stratio.deep.cassandra.filter.value.EqualsInValue;
import com.stratio.deep.cassandra.util.CassandraUtils;
import com.stratio.deep.commons.config.DeepJobConfig;
import com.stratio.deep.commons.config.ExtractorConfig;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.exception.DeepIOException;
import com.stratio.deep.commons.exception.DeepIndexNotFoundException;
import com.stratio.deep.commons.exception.DeepNoSuchFieldException;
import com.stratio.deep.commons.filter.Filter;
import com.stratio.deep.commons.utils.Utils;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import scala.Tuple2;

public abstract class CassandraDeepJobConfig<T>
extends DeepJobConfig<T, CassandraDeepJobConfig<T>>
implements AutoCloseable,
ICassandraDeepJobConfig<T> {
    private static final Logger LOG = Logger.getLogger((String)"com.stratio.deep.config.GenericICassandraDeepJobConfig");
    private static final long serialVersionUID = -7179376653643603038L;
    private String partitionerClassName = "org.apache.cassandra.dht.Murmur3Partitioner";
    private Integer rpcPort = 9160;
    private Integer cqlPort = 9042;
    private final Map<String, Serializable> additionalFilters = new TreeMap<String, Serializable>();
    private int batchSize = 100;
    private transient Map<String, Cell> columnDefinitionMap;
    private String readConsistencyLevel = ConsistencyLevel.LOCAL_ONE.name();
    private String writeConsistencyLevel = ConsistencyLevel.QUORUM.name();
    protected Boolean createTableOnWrite = Boolean.TRUE;
    private transient Session session;
    private Boolean isInitialized = Boolean.FALSE;
    private int pageSize = 1000;
    protected Boolean isWriteConfig = Boolean.TRUE;
    private int bisectFactor = 1;
    private final int splitSize = 100000;
    private boolean isSplitModeSet = false;
    private boolean isBisectModeSet = true;
    private EqualsInValue equalsInValue = null;
    public static ProtocolVersion PROTOCOL_VERSION = ProtocolVersion.V2;

    @Override
    public CassandraDeepJobConfig<T> session(Session session) {
        this.session = session;
        return this;
    }

    @Override
    public synchronized Session getSession() {
        if (this.session == null) {
            Cluster cluster = Cluster.builder().withPort(this.cqlPort.intValue()).addContactPoint(this.getHost()).withCredentials(this.username, this.password).withProtocolVersion(PROTOCOL_VERSION).build();
            this.session = cluster.connect(Utils.quote((String)this.catalog));
        }
        return this.session;
    }

    @Override
    public void close() {
        LOG.debug((Object)("closing " + this.getClass().getCanonicalName()));
        if (this.session != null) {
            this.session.close();
        }
    }

    public CassandraDeepJobConfig(Class<T> entityClass) {
        super(entityClass);
    }

    protected void checkInitialized() {
        if (!this.isInitialized.booleanValue()) {
            this.initialize();
            LOG.warn((Object)"CassandraDeepJobConfig has not been initialized!");
        }
    }

    public TableMetadata fetchTableMetadata() {
        Metadata metadata = this.getSession().getCluster().getMetadata();
        KeyspaceMetadata ksMetadata = metadata.getKeyspace(Utils.quote((String)this.catalog));
        if (ksMetadata != null) {
            return ksMetadata.getTable(Utils.quote((String)this.table));
        }
        return null;
    }

    public void createOutputTableIfNeeded(Tuple2<Cells, Cells> first) {
        TableMetadata metadata = this.getSession().getCluster().getMetadata().getKeyspace(this.catalog).getTable(Utils.quote((String)this.table));
        if (metadata == null && !this.createTableOnWrite.booleanValue()) {
            throw new DeepIOException("Cannot write RDD, output table does not exists and configuration object has 'createTableOnWrite' = false");
        }
        if (metadata != null) {
            return;
        }
        if (first._1() == null || ((Cells)first._1()).isEmpty()) {
            throw new DeepNoSuchFieldException("no key structure found on row metadata");
        }
        String createTableQuery = CassandraUtils.createTableQueryGenerator((Cells)first._1(), (Cells)first._2(), this.catalog, Utils.quote((String)this.table));
        this.getSession().execute(createTableQuery);
        this.waitForNewTableMetadata();
    }

    private void waitForNewTableMetadata() {
        TableMetadata metadata;
        int retries = 0;
        int waitTime = 100;
        do {
            if ((metadata = this.getSession().getCluster().getMetadata().getKeyspace(this.catalog).getTable(Utils.quote((String)this.table))) != null) continue;
            LOG.warn((Object)String.format("Metadata for new table %s.%s NOT FOUND, waiting %d millis", this.catalog, this.table, 100));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Sleep interrupted", (Throwable)e);
            }
            if (++retries < 10) continue;
            throw new DeepIOException("Cannot retrieve metadata for the newly created CF ");
        } while (metadata == null);
    }

    @Override
    public synchronized Map<String, Cell> columnDefinitions() {
        if (this.columnDefinitionMap != null) {
            return this.columnDefinitionMap;
        }
        TableMetadata tableMetadata = this.fetchTableMetadata();
        if (tableMetadata == null && !this.createTableOnWrite.booleanValue()) {
            LOG.warn((Object)"Configuration not suitable for writing RDD: output table does not exists and configuration object has 'createTableOnWrite' = false");
            return null;
        }
        if (tableMetadata == null) {
            return null;
        }
        this.initColumnDefinitionMap(tableMetadata);
        return this.columnDefinitionMap;
    }

    private void initColumnDefinitionMap(TableMetadata tableMetadata) {
        Cell metadata;
        this.columnDefinitionMap = new HashMap<String, Cell>();
        List partitionKeys = tableMetadata.getPartitionKey();
        List clusteringKeys = tableMetadata.getClusteringColumns();
        List allColumns = tableMetadata.getColumns();
        for (ColumnMetadata key : partitionKeys) {
            metadata = Cell.create((String)key.getName(), (Object)key.getType(), (Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE);
            this.columnDefinitionMap.put(key.getName(), metadata);
        }
        for (ColumnMetadata key : clusteringKeys) {
            metadata = Cell.create((String)key.getName(), (Object)key.getType(), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            this.columnDefinitionMap.put(key.getName(), metadata);
        }
        for (ColumnMetadata key : allColumns) {
            metadata = Cell.create((String)key.getName(), (Object)key.getType(), (Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE);
            if (this.columnDefinitionMap.containsKey(key.getName())) continue;
            this.columnDefinitionMap.put(key.getName(), metadata);
        }
        this.columnDefinitionMap = Collections.unmodifiableMap(this.columnDefinitionMap);
    }

    @Override
    public CassandraDeepJobConfig<T> columnFamily(String columnFamily) {
        this.table = columnFamily;
        return this;
    }

    @Override
    public CassandraDeepJobConfig<T> table(String table) {
        return this.columnFamily(table);
    }

    @Override
    public String getColumnFamily() {
        this.checkInitialized();
        return this.table;
    }

    @Override
    public String getTable() {
        return this.getColumnFamily();
    }

    @Override
    public String getKeyspace() {
        this.checkInitialized();
        return this.catalog;
    }

    @Override
    public String getPartitionerClassName() {
        this.checkInitialized();
        return this.partitionerClassName;
    }

    public String getPassword() {
        this.checkInitialized();
        return this.password;
    }

    @Override
    public Integer getRpcPort() {
        this.checkInitialized();
        return this.rpcPort;
    }

    @Override
    public Integer getCqlPort() {
        this.checkInitialized();
        return this.cqlPort;
    }

    @Override
    public CassandraDeepJobConfig<T> initialize() {
        if (this.isInitialized.booleanValue()) {
            return this;
        }
        if (StringUtils.isEmpty((String)this.getHost())) {
            try {
                this.host.add(InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (UnknownHostException e) {
                LOG.warn((Object)"Cannot resolve local host canonical name, using \"localhost\"");
                this.host.add(InetAddress.getLoopbackAddress().getCanonicalHostName());
            }
        }
        this.validate();
        this.columnDefinitions();
        this.isInitialized = Boolean.TRUE;
        return this;
    }

    public CassandraDeepJobConfig<T> initialize(ExtractorConfig extractorConfig) {
        super.initialize(extractorConfig);
        Map values = extractorConfig.getValues();
        if (values.get("batchSize") != null) {
            this.batchSize(extractorConfig.getInteger("batchSize"));
        }
        if (values.get("Port") != null) {
            this.cqlPort(extractorConfig.getInteger("Port"));
        }
        if (values.get("port2") != null) {
            this.rpcPort(extractorConfig.getInteger("port2"));
        }
        if (values.get("createOnWrite") != null) {
            this.createTableOnWrite(extractorConfig.getBoolean("createOnWrite"));
        }
        if (values.get("page") != null) {
            this.pageSize(extractorConfig.getInteger("page"));
        }
        if (values.get("readConsistencyLevel") != null) {
            this.readConsistencyLevel(extractorConfig.getString("readConsistencyLevel"));
        }
        if (values.get("writeConsistencyLevel") != null) {
            this.writeConsistencyLevel(extractorConfig.getString("writeConsistencyLevel"));
        }
        if (values.get("bisecFactor") != null) {
            this.bisectFactor(extractorConfig.getInteger("bisecFactor"));
        }
        if (values.get("filterQuery") != null) {
            this.filters(extractorConfig.getFilterArray("filterQuery"));
        }
        if (values.get("equalsInFilter") != null) {
            this.setEqualsInValue((EqualsInValue)extractorConfig.getValue(EqualsInValue.class, "equalsInFilter"));
        }
        this.initialize();
        return this;
    }

    @Override
    public CassandraDeepJobConfig<T> filters(Filter ... filters) {
        this.filters = filters;
        return this;
    }

    @Override
    public Filter[] getFilters() {
        return this.filters;
    }

    @Override
    public CassandraDeepJobConfig<T> keyspace(String keyspace) {
        this.catalog = keyspace;
        return this;
    }

    @Override
    public CassandraDeepJobConfig<T> bisectFactor(int bisectFactor) {
        this.isSplitModeSet = false;
        this.isBisectModeSet = true;
        this.bisectFactor = bisectFactor;
        return this;
    }

    @Override
    public CassandraDeepJobConfig<T> partitioner(String partitionerClassName) {
        this.partitionerClassName = partitionerClassName;
        return this;
    }

    public CassandraDeepJobConfig<T> password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public CassandraDeepJobConfig<T> rpcPort(Integer port) {
        this.rpcPort = port;
        return this;
    }

    @Override
    public CassandraDeepJobConfig<T> cqlPort(Integer port) {
        this.cqlPort = port;
        return this;
    }

    public CassandraDeepJobConfig<T> username(String username) {
        this.username = username;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void validate() {
        this.validateCassandraParams();
        if (this.pageSize <= 0) {
            throw new IllegalArgumentException("pageSize cannot be zero");
        }
        if (this.pageSize > 10000) {
            throw new IllegalArgumentException("pageSize cannot exceed 10000");
        }
        this.validateConsistencyLevels();
        TableMetadata tableMetadata = this.fetchTableMetadata();
        this.validateTableMetadata(tableMetadata);
        this.validateAdditionalFilters(tableMetadata);
        if (this.isBisectModeSet && this.isSplitModeSet) throw new IllegalArgumentException("Only one split mode can be defined, please choose between Split or Bisect");
        if (this.isBisectModeSet) {
            if (this.bisectFactor == 1 || this.checkIsPowerOfTwo(this.bisectFactor)) return;
            throw new IllegalArgumentException("Bisect factor should be greater than zero and a power of 2");
        }
        if (!this.isSplitModeSet) throw new IllegalArgumentException("One split mode must be defined, please choose between Split or Bisect");
        if (this.splitSize > 0) return;
        throw new IllegalArgumentException("The split size must be a positve integer");
    }

    private void validateCassandraParams() {
        if (StringUtils.isEmpty((String)this.getHost())) {
            throw new IllegalArgumentException("host cannot be null");
        }
        if (this.rpcPort == null) {
            throw new IllegalArgumentException("rpcPort cannot be null");
        }
        if (StringUtils.isEmpty((String)this.catalog)) {
            throw new IllegalArgumentException("keyspace cannot be null");
        }
        if (StringUtils.isEmpty((String)this.table)) {
            throw new IllegalArgumentException("columnFamily cannot be null");
        }
    }

    private void validateTableMetadata(TableMetadata tableMetadata) {
        if (tableMetadata == null && !this.isWriteConfig.booleanValue()) {
            throw new IllegalArgumentException(String.format("Column family {%s.%s} does not exist", this.catalog, this.table));
        }
        if (tableMetadata == null && !this.createTableOnWrite.booleanValue()) {
            throw new IllegalArgumentException(String.format("Column family {%s.%s} does not exist and createTableOnWrite = false", this.catalog, this.table));
        }
        if (!ArrayUtils.isEmpty((Object[])this.inputColumns)) {
            for (String column : this.inputColumns) {
                assert (tableMetadata != null);
                ColumnMetadata columnMetadata = tableMetadata.getColumn(column);
                if (columnMetadata != null) continue;
                throw new DeepNoSuchFieldException("No column with name " + column + " has been found on table " + this.catalog + "." + this.table);
            }
        }
    }

    private void validateAdditionalFilters(TableMetadata tableMetadata) {
        for (Map.Entry<String, Serializable> entry : this.additionalFilters.entrySet()) {
            ColumnMetadata columnMetadata = tableMetadata.getColumn(entry.getKey());
            if (columnMetadata == null) {
                throw new DeepNoSuchFieldException("No column with name " + entry.getKey() + " has been found on " + "table " + this.catalog + "." + this.table);
            }
            if (columnMetadata.getIndex() != null) continue;
            throw new DeepIndexNotFoundException("No index has been found on column " + columnMetadata.getName() + " on table " + this.catalog + "." + this.table);
        }
    }

    private void validateConsistencyLevels() {
        if (this.readConsistencyLevel != null) {
            try {
                ConsistencyLevel.valueOf((String)this.readConsistencyLevel);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("readConsistencyLevel not valid, should be one of thos defined in org.apache.cassandra.db.ConsistencyLevel", e);
            }
        }
        if (this.writeConsistencyLevel != null) {
            try {
                ConsistencyLevel.valueOf((String)this.writeConsistencyLevel);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("writeConsistencyLevel not valid, should be one of those defined in org.apache.cassandra.db.ConsistencyLevel", e);
            }
        }
    }

    private boolean checkIsPowerOfTwo(int n) {
        return n > 0 && (n & n - 1) == 0;
    }

    @Override
    public CassandraDeepJobConfig<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public Boolean isCreateTableOnWrite() {
        return this.createTableOnWrite;
    }

    @Override
    public CassandraDeepJobConfig<T> createTableOnWrite(Boolean createTableOnWrite) {
        this.createTableOnWrite = createTableOnWrite;
        this.isWriteConfig = createTableOnWrite;
        return this;
    }

    @Override
    public Map<String, Serializable> getAdditionalFilters() {
        return Collections.unmodifiableMap(this.additionalFilters);
    }

    public int getPageSize() {
        this.checkInitialized();
        return this.pageSize;
    }

    public CassandraDeepJobConfig<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    @Override
    public String getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    @Override
    public CassandraDeepJobConfig<T> readConsistencyLevel(String level) {
        this.readConsistencyLevel = level;
        return this;
    }

    @Override
    public CassandraDeepJobConfig<T> writeConsistencyLevel(String level) {
        this.writeConsistencyLevel = level;
        return this;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Boolean getIsWriteConfig() {
        return this.isWriteConfig;
    }

    @Override
    public int getBisectFactor() {
        return this.bisectFactor;
    }

    @Override
    public CassandraDeepJobConfig<T> splitSize(int splitSize) {
        return this;
    }

    @Override
    public Integer getSplitSize() {
        return this.splitSize;
    }

    @Override
    public boolean isSplitModeSet() {
        return this.isSplitModeSet;
    }

    @Override
    public boolean isBisectModeSet() {
        return this.isBisectModeSet;
    }

    public EqualsInValue getEqualsInValue() {
        return this.equalsInValue;
    }

    public void setEqualsInValue(EqualsInValue equalsInValue) {
        this.equalsInValue = equalsInValue;
    }
}

