/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.config;

import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.extractor.CassandraEntityExtractor;
import com.stratio.deep.commons.annotations.DeepEntity;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.exception.DeepIOException;
import com.stratio.deep.commons.exception.DeepNoSuchFieldException;
import com.stratio.deep.commons.utils.AnnotationUtils;
import com.stratio.deep.commons.utils.Utils;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public final class EntityDeepJobConfig<T extends IDeepType>
extends CassandraDeepJobConfig<T> {
    private static final long serialVersionUID = 4490719746563473495L;
    private Map<String, String> mapDBNameToEntityName;

    @Override
    public CassandraDeepJobConfig<T> initialize() {
        Field[] deepFields;
        super.initialize();
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        for (Field f : deepFields = AnnotationUtils.filterDeepFields((Class)this.entityClass)) {
            String dbName = AnnotationUtils.deepFieldName((Field)f);
            String beanFieldName = f.getName();
            tmpMap.put(dbName, beanFieldName);
        }
        this.mapDBNameToEntityName = Collections.unmodifiableMap(tmpMap);
        return this;
    }

    public Configuration getHadoopConfiguration() {
        return null;
    }

    public EntityDeepJobConfig(Class<T> entityClass) {
        super(entityClass);
        this.setExtractorImplClass(CassandraEntityExtractor.class);
    }

    public EntityDeepJobConfig(Class<T> entityClass, boolean isWriteConfig) {
        this(entityClass);
        this.isWriteConfig = isWriteConfig;
        this.createTableOnWrite = isWriteConfig;
    }

    @Override
    public void validate() {
        if (this.entityClass == null) {
            throw new IllegalArgumentException("testentity class cannot be null");
        }
        if (!this.entityClass.isAnnotationPresent(DeepEntity.class)) {
            throw new AnnotationTypeMismatchException(null, this.entityClass.getCanonicalName());
        }
        super.validate();
        Field[] deepFields = AnnotationUtils.filterDeepFields((Class)this.entityClass);
        Map<String, Cell> colDefs = super.columnDefinitions();
        if (colDefs == null) {
            return;
        }
        for (Field field : deepFields) {
            String annotationFieldName = AnnotationUtils.deepFieldName((Field)field);
            if (colDefs.containsKey(annotationFieldName)) continue;
            throw new DeepNoSuchFieldException("Unknown column name '" + annotationFieldName + "' specified for" + " field " + this.entityClass.getCanonicalName() + "#" + field.getName() + ". Please, " + "make sure the field name you specify in @DeepField annotation matches _exactly_ the column " + "name " + "in the database");
        }
    }

    public void setInstancePropertyFromDbName(T instance, String dbName, Object value) {
        Map<String, Cell> cfs = this.columnDefinitions();
        Cell metadataCell = cfs.get(dbName);
        String f = this.mapDBNameToEntityName.get(dbName);
        if (StringUtils.isEmpty((String)f)) {
            return;
        }
        try {
            Method setter = Utils.findSetter((String)f, (Class)this.entityClass, value.getClass());
            setter.invoke(instance, value);
        }
        catch (DeepIOException e) {
            Utils.setFieldWithReflection(instance, (String)f, (Object)value);
        }
        catch (Exception e1) {
            throw new DeepGenericException((Throwable)e1);
        }
    }
}

