/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.config;

import com.stratio.deep.commons.filter.FilterType;

public enum OperatorCassandra {
    IS(FilterType.EQ, "="),
    GT(FilterType.GT, ">"),
    GTE(FilterType.GTE, ">="),
    LT(FilterType.LT, "<"),
    LTE(FilterType.LTE, "<="),
    NE(FilterType.NEQ, "!=");

    private FilterType filterType;
    private String operator;

    private OperatorCassandra(FilterType filterType, String operator) {
        this.filterType = filterType;
        this.operator = operator;
    }

    public static OperatorCassandra getOperatorCassandra(FilterType filterType) {
        switch (filterType) {
            case EQ: {
                return IS;
            }
            case GT: {
                return GT;
            }
            case GTE: {
                return GTE;
            }
            case LT: {
                return LT;
            }
            case LTE: {
                return LTE;
            }
            case NEQ: {
                return NE;
            }
        }
        return null;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public String getOperator() {
        return this.operator;
    }
}

