/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.Policies;
import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.cql.LocalMachineLoadBalancingPolicy;
import com.stratio.deep.commons.exception.DeepIOException;
import com.stratio.deep.commons.utils.Pair;
import com.stratio.deep.commons.utils.Utils;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClientProvider {
    private static final transient Map<String, Session> CLIENTS_CACHE = Collections.synchronizedMap(new HashMap());
    private static final Logger LOG = LoggerFactory.getLogger(CassandraClientProvider.class);

    CassandraClientProvider() {
    }

    static Pair<Session, String> trySessionForLocation(String location, CassandraDeepJobConfig conf, Boolean balanced) {
        try {
            return CassandraClientProvider.getSession(location, conf, balanced);
        }
        catch (Exception e) {
            LOG.warn("Could not connect to {}, possible loss of data-locality. Delegating connection to java driver", (Object)location, (Object)conf.getHost());
            return CassandraClientProvider.getSession(conf.getHost(), conf, true);
        }
    }

    static Pair<Session, String> getSession(String location, CassandraDeepJobConfig conf, Boolean balanced) {
        assert (balanced != null);
        Map<String, Session> map = CLIENTS_CACHE;
        synchronized (map) {
            int port = conf.getCqlPort();
            String key = location + ":" + port + ":" + conf.getKeyspace() + ":" + balanced;
            if (CLIENTS_CACHE.containsKey(key)) {
                LOG.trace("Found cached session at level 1 for key {{}}", (Object)key);
                return Pair.create((Object)CLIENTS_CACHE.get(key), (Object)location);
            }
            if (balanced.booleanValue() && location.equals(conf.getHost())) {
                CLIENTS_CACHE.put(key, conf.getSession());
                LOG.trace("Found cached session at level 2 for key {{}}", (Object)key);
                return Pair.create((Object)CLIENTS_CACHE.get(key), (Object)location);
            }
            try {
                LOG.debug("No cached session found for key {{}}", (Object)key);
                InetAddress locationInet = InetAddress.getByName(location);
                Object loadBalancingPolicy = balanced != false ? Policies.defaultLoadBalancingPolicy() : new LocalMachineLoadBalancingPolicy(locationInet);
                Cluster cluster = Cluster.builder().withPort(port).addContactPoint(location).withLoadBalancingPolicy(loadBalancingPolicy).withProtocolVersion(ProtocolVersion.V2).withCredentials(conf.getUsername(), conf.getPassword()).build();
                Session session = cluster.connect(Utils.quote((String)conf.getKeyspace()));
                CLIENTS_CACHE.put(key, session);
                return Pair.create((Object)CLIENTS_CACHE.get(key), (Object)location);
            }
            catch (Exception e) {
                throw new DeepIOException("Failed to create authenticated client to {" + location + "}:{" + port + "}", (Throwable)e);
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = CLIENTS_CACHE;
                synchronized (map) {
                    if (CLIENTS_CACHE != null && !CLIENTS_CACHE.isEmpty()) {
                        LOG.info("Closing clients ");
                        for (Session entry : CLIENTS_CACHE.values()) {
                            if (entry == null) continue;
                            entry.close();
                        }
                    }
                }
            }
        });
    }
}

