/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.cql;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.config.ICassandraDeepJobConfig;
import com.stratio.deep.cassandra.cql.CassandraClientProvider;
import com.stratio.deep.cassandra.querybuilder.CassandraUpdateQueryBuilder;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.exception.DeepInstantiationException;
import com.stratio.deep.commons.handler.DeepRecordWriter;
import com.stratio.deep.commons.utils.Utils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeepCqlRecordWriter
extends DeepRecordWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DeepCqlRecordWriter.class);
    private static final int MAX_PARALLEL_QUERIES = 4;
    private static final int WORK_QUEUE_SIZE = 8;
    private final ListeningExecutorService taskExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Utils.newBlockingFixedThreadPoolExecutor((int)4, (int)8));
    private final ConcurrentHashMap<String, ListenableFuture<?>> pendingTasks = new ConcurrentHashMap();
    private WriteTask currentTask;
    private boolean hasCurrentTask = false;
    private final ICassandraDeepJobConfig writeConfig;
    private final CassandraUpdateQueryBuilder queryBuilder;
    private Session sessionWithHost;

    public DeepCqlRecordWriter(ICassandraDeepJobConfig writeConfig, CassandraUpdateQueryBuilder queryBuilder) {
        this.writeConfig = writeConfig;
        this.queryBuilder = queryBuilder;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            this.sessionWithHost = (Session)CassandraClientProvider.trySessionForLocation((String)localhost.getHostAddress(), (CassandraDeepJobConfig)((CassandraDeepJobConfig)writeConfig), (Boolean)Boolean.valueOf((boolean)false)).left;
            this.sessionWithHost.init();
        }
        catch (UnknownHostException e) {
            throw new DeepInstantiationException("Cannot resolve local hostname", (Throwable)e);
        }
    }

    public void close() {
        LOG.debug("Closing all writer tasks");
        if (this.hasCurrentTask) {
            this.executeTaskAsync();
        }
        this.waitForCompletion();
        this.taskExecutorService.shutdown();
    }

    public void write(Cells keys, Cells values) {
        if (!this.hasCurrentTask) {
            String localCql = this.queryBuilder.prepareQuery(keys, values);
            this.currentTask = new WriteTask(localCql);
            this.hasCurrentTask = true;
        }
        ArrayList<Object> allValues = new ArrayList<Object>(values.getCellValues());
        allValues.addAll(keys.getCellValues());
        this.currentTask.add(allValues);
        if (this.isBatchSizeReached()) {
            this.executeTaskAsync();
        }
    }

    private boolean isBatchSizeReached() {
        return this.currentTask.size() >= this.writeConfig.getBatchSize();
    }

    private void executeTaskAsync() {
        final String taskId = this.currentTask.getId();
        ListenableFuture future = this.taskExecutorService.submit((Runnable)this.currentTask);
        this.pendingTasks.put(taskId, future);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                DeepCqlRecordWriter.this.pendingTasks.remove(taskId);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.hasCurrentTask = false;
    }

    private void waitForCompletion() {
        for (ListenableFuture<?> future : this.pendingTasks.values()) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("[" + (Object)((Object)this) + "] Error waiting for writes to complete: " + e.getMessage());
            }
        }
    }

    class WriteTask
    implements Runnable {
        private final UUID id = UUID.randomUUID();
        private final String cql;
        private final List<List<Object>> records = new ArrayList<List<Object>>();

        public WriteTask(String cql) {
            this.cql = cql;
        }

        public void add(List<Object> values) {
            this.records.add(values);
        }

        public int size() {
            return this.records.size();
        }

        public String getId() {
            return this.id.toString();
        }

        @Override
        public void run() {
            LOG.debug("[" + this + "] Executing batch write to cassandra");
            try {
                PreparedStatement preparedStatement = DeepCqlRecordWriter.this.sessionWithHost.prepare(this.cql);
                BatchStatement batchStatement = new BatchStatement(BatchStatement.Type.UNLOGGED);
                for (List<Object> record : this.records) {
                    batchStatement.add((Statement)preparedStatement.bind(record.toArray(new Object[record.size()])));
                }
                DeepCqlRecordWriter.this.sessionWithHost.execute((Statement)batchStatement);
            }
            catch (Exception e) {
                LOG.error("[" + this + "] Exception occurred while trying to execute batch in cassandra: " + e.getMessage());
            }
        }
    }
}

