/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.google.common.collect.AbstractIterator;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class LocalMachineLoadBalancingPolicy
extends RoundRobinPolicy {
    private InetAddress host;
    private final CopyOnWriteArrayList<Host> liveHosts = new CopyOnWriteArrayList();
    private final AtomicInteger index = new AtomicInteger();

    public LocalMachineLoadBalancingPolicy(InetAddress host) {
        this.host = host;
    }

    public void init(Cluster cluster, Collection<Host> hosts) {
        for (Host h : hosts) {
            if (!h.getAddress().equals(this.host)) continue;
            this.liveHosts.add(h);
            this.index.set(0);
            break;
        }
    }

    public HostDistance distance(Host host) {
        return HostDistance.LOCAL;
    }

    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        final List hosts = (List)this.liveHosts.clone();
        final int startIdx = this.index.getAndIncrement();
        if (startIdx > 2147473647) {
            this.index.set(0);
        }
        return new AbstractIterator<Host>(){
            private int idx;
            private int remaining;
            {
                this.idx = startIdx;
                this.remaining = hosts.size();
            }

            protected Host computeNext() {
                int c;
                if (this.remaining <= 0) {
                    return (Host)this.endOfData();
                }
                --this.remaining;
                if ((c = this.idx++ % hosts.size()) < 0) {
                    c += hosts.size();
                }
                return (Host)hosts.get(c);
            }
        };
    }

    public void onUp(Host host) {
        this.liveHosts.addIfAbsent(host);
    }

    public void onDown(Host host) {
        this.liveHosts.remove(host);
    }

    public void onAdd(Host host) {
        if (this.liveHosts.isEmpty()) {
            this.onUp(host);
        }
    }

    public void onRemove(Host host) {
        this.onDown(host);
    }
}

