/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.entity;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.stratio.deep.cassandra.entity.CellValidator;
import com.stratio.deep.commons.annotations.DeepField;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.exception.DeepInstantiationException;
import com.stratio.deep.commons.utils.AnnotationUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;

@Deprecated
public class CassandraCell
extends Cell {
    private transient CellValidator cellValidator;
    private transient DataType dataType;

    public static Cell create(Cell basicCell) {
        return new CassandraCell(basicCell);
    }

    public static Cell create(Cell metadata, Object cellValue) {
        return new CassandraCell(metadata, cellValue);
    }

    public static Cell create(Cell metadata, ByteBuffer cellValue) {
        return new CassandraCell(metadata, cellValue);
    }

    public static Cell create(String cellName, Object cellValue) {
        return CassandraCell.create(cellName, cellValue, Boolean.FALSE, Boolean.FALSE);
    }

    public static Cell create(String cellName) {
        return CassandraCell.create(cellName, (Object)null, Boolean.FALSE, Boolean.FALSE);
    }

    public static Cell create(String cellName, Object cellValue, Boolean isPartitionKey, Boolean isClusterKey) {
        return new CassandraCell(cellName, cellValue, isPartitionKey, isClusterKey);
    }

    public static Cell create(String cellName, DataType cellType, Boolean isPartitionKey, Boolean isClusterKey) {
        return new CassandraCell(cellName, cellType, isPartitionKey, isClusterKey);
    }

    public static <E extends IDeepType> Cell create(E e, Field field) {
        return new CassandraCell(e, field);
    }

    public static CellValidator getValueType(DataType obj) {
        return CellValidator.cellValidator(obj);
    }

    public static CellValidator getValueType(Object obj) {
        return CellValidator.cellValidator(obj);
    }

    private CassandraCell(String cellName, Object cellValue, Boolean isPartitionKey, Boolean isClusterKey) {
        if (cellValue != null && !(cellValue instanceof Serializable)) {
            throw new DeepInstantiationException("provided cell value " + cellValue + " is not serializable");
        }
        this.cellName = cellName;
        this.cellValue = cellValue;
        this.isKey = isPartitionKey;
        this.isClusterKey = isClusterKey;
        this.cellValidator = CassandraCell.getValueType(cellValue);
    }

    private CassandraCell(String cellName, DataType cellType, Boolean isPartitionKey, Boolean isClusterKey) {
        this.cellName = cellName;
        this.isClusterKey = isClusterKey;
        this.dataType = cellType;
        this.isKey = isPartitionKey;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private CassandraCell(Cell metadata, ByteBuffer cellValue) {
        this.cellName = metadata.getCellName();
        this.isClusterKey = ((CassandraCell)metadata).isClusterKey;
        this.isKey = ((CassandraCell)metadata).isPartitionKey();
        this.cellValidator = ((CassandraCell)metadata).cellValidator;
        if (cellValue != null) {
            this.cellValue = ((CassandraCell)metadata).getDataType() != null ? ((CassandraCell)metadata).getDataType().deserialize(cellValue, ProtocolVersion.V2) : ((CassandraCell)metadata).marshaller().compose(cellValue);
        }
    }

    private CassandraCell(Cell metadata, Object cellValue) {
        if (!(cellValue instanceof Serializable)) {
            throw new DeepInstantiationException("provided cell value " + cellValue + " is not serializable");
        }
        this.cellName = metadata.getCellName();
        this.isClusterKey = ((CassandraCell)metadata).isClusterKey;
        this.isKey = ((CassandraCell)metadata).isPartitionKey();
        this.cellValidator = ((CassandraCell)metadata).cellValidator;
        this.cellValue = cellValue;
    }

    private CassandraCell(Cell cell) {
        this.cellName = cell.getCellName();
        this.cellValue = cell.getCellValue();
        this.isKey = cell.isKey();
        this.cellValidator = CassandraCell.getValueType(this.cellValue);
    }

    private CassandraCell(IDeepType e, Field field) {
        DeepField annotation = field.getAnnotation(DeepField.class);
        this.cellName = AnnotationUtils.deepFieldName((Field)field);
        this.cellValue = AnnotationUtils.getBeanFieldValue((IDeepType)e, (Field)field);
        this.isClusterKey = annotation.isPartOfClusterKey();
        this.isKey = annotation.isPartOfPartitionKey();
        this.cellValidator = CellValidator.cellValidator(field);
    }

    public CellValidator getCellValidator() {
        return this.cellValidator;
    }

    public Class getValueType() {
        Class valueType = com.stratio.deep.cassandra.util.AnnotationUtils.MAP_ABSTRACT_TYPE_CLASSNAME_TO_JAVA_TYPE.get(this.cellValidator.getValidatorClassName());
        if (valueType == null) {
            throw new DeepGenericException("Cannot find value type for marshaller " + this.cellValidator.getValidatorClassName());
        }
        return valueType;
    }

    public ByteBuffer getDecomposedCellValue() {
        if (this.cellValue != null) {
            return this.marshaller().decompose(this.cellValue);
        }
        return ByteBuffer.wrap(new byte[0]);
    }

    public Boolean isClusterKey() {
        return this.isClusterKey;
    }

    public Boolean isPartitionKey() {
        return this.isKey;
    }

    public Boolean isKey() {
        return this.isClusterKey != false || this.isKey != false;
    }

    public AbstractType marshaller() {
        if (this.cellValidator != null) {
            return this.cellValidator.getAbstractType();
        }
        return null;
    }

    public String marshallerClassName() {
        if (this.cellValidator != null) {
            return this.cellValidator.getValidatorClassName();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CassandraCell{");
        sb.append("cellName='").append(this.cellName).append('\'');
        sb.append(", cellValue=").append(this.cellValue);
        sb.append(", isPartitionKey=").append(this.isKey);
        sb.append(", isClusterKey=").append(this.isClusterKey);
        sb.append(", cellValidator=").append(this.cellValidator);
        sb.append('}');
        return sb.toString();
    }
}

