/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.extractor;

import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.config.CellDeepJobConfig;
import com.stratio.deep.cassandra.extractor.CassandraExtractor;
import com.stratio.deep.cassandra.functions.CellList2TupleFunction;
import com.stratio.deep.cassandra.util.CassandraUtils;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.utils.Pair;
import java.nio.ByteBuffer;
import java.util.Map;

public class CassandraCellExtractor
extends CassandraExtractor<Cells, CellDeepJobConfig> {
    private static final long serialVersionUID = -738528971629963221L;

    public CassandraCellExtractor() {
        this(Cells.class);
    }

    public CassandraCellExtractor(Class<Cells> entityClass) {
        this.cassandraJobConfig = new CellDeepJobConfig();
        this.transformer = new CellList2TupleFunction();
    }

    @Override
    public Cells transformElement(Pair<Map<String, ByteBuffer>, Map<String, ByteBuffer>> elem, CassandraDeepJobConfig<Cells> config) {
        Cell cd;
        Cells cells = new Cells(config.getNameSpace());
        Map<String, Cell> columnDefinitions = config.columnDefinitions();
        for (Map.Entry entry : ((Map)elem.left).entrySet()) {
            cd = columnDefinitions.get(entry.getKey());
            cells.add(CassandraUtils.createFromByteBuffer(cd, (ByteBuffer)entry.getValue()));
        }
        for (Map.Entry entry : ((Map)elem.right).entrySet()) {
            cd = columnDefinitions.get(entry.getKey());
            if (cd == null) continue;
            cells.add(CassandraUtils.createFromByteBuffer(cd, (ByteBuffer)entry.getValue()));
        }
        return cells;
    }

    @Override
    public Class getConfigClass() {
        return CellDeepJobConfig.class;
    }
}

