/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.querybuilder;

import com.stratio.deep.cassandra.querybuilder.CassandraUpdateQueryBuilder;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.utils.Utils;
import java.util.List;

public class DefaultQueryBuilder
extends CassandraUpdateQueryBuilder {
    public String prepareQuery(Cells keys, Cells values) {
        StringBuilder sb = new StringBuilder("UPDATE ").append(Utils.quote((String)this.getCatalogName())).append(".").append(Utils.quote((String)this.getTableName())).append(" SET ");
        boolean isFirst = true;
        StringBuilder keyClause = new StringBuilder(" WHERE ");
        for (Cell cell : keys.getCells()) {
            if (!isFirst) {
                keyClause.append(" AND ");
            } else {
                isFirst = false;
            }
            keyClause.append(String.format("%s = ?", Utils.quote((String)cell.getCellName())));
        }
        isFirst = true;
        for (Cell cell : values.getCells()) {
            if (!isFirst) {
                sb.append(", ");
            } else {
                isFirst = false;
            }
            sb.append(String.format("%s = ?", Utils.quote((String)cell.getCellName())));
        }
        sb.append((CharSequence)keyClause).append(";");
        return sb.toString();
    }

    public String prepareBatchQuery(List<String> statements) {
        StringBuilder sb = new StringBuilder("BEGIN BATCH \n");
        for (String statement : statements) {
            sb.append(statement).append("\n");
        }
        sb.append(" APPLY BATCH;");
        return sb.toString();
    }
}

