/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.thrift;

import java.io.Closeable;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class ThriftClient
extends Cassandra.Client
implements Closeable {
    private ThriftClient(TProtocol protocol) {
        super(protocol);
    }

    public static ThriftClient build(String host, int port, String keyspace) throws TException {
        TFramedTransport transport = new TFramedTransport((TTransport)new TSocket(host, port));
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        ThriftClient client = new ThriftClient((TProtocol)protocol);
        transport.open();
        if (keyspace != null) {
            client.set_keyspace(keyspace);
        }
        return client;
    }

    public static ThriftClient build(String host, int port) throws TException {
        return ThriftClient.build(host, port, null);
    }

    @Override
    public void close() {
        this.getInputProtocol().getTransport().close();
    }
}

