/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.cassandra.thrift;

import com.stratio.deep.cassandra.config.CassandraDeepJobConfig;
import com.stratio.deep.cassandra.thrift.ThriftClient;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.rdd.DeepTokenRange;
import com.stratio.deep.commons.utils.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.thrift.CfSplit;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftRangeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftRangeUtils.class);
    private final String host;
    private final int rpcPort;
    private final int splitSize;
    private final String keyspace;
    private final String columnFamily;
    private final AbstractType tokenType;
    private final Token.TokenFactory tokenFactory;
    private final Comparable minToken;

    public ThriftRangeUtils(IPartitioner partitioner, String host, int rpcPort, String keyspace, String columnFamily, int splitSize) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.splitSize = splitSize;
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.tokenType = partitioner.getTokenValidator();
        this.tokenFactory = partitioner.getTokenFactory();
        this.minToken = (Comparable)partitioner.getMinimumToken().token;
    }

    public static ThriftRangeUtils build(CassandraDeepJobConfig config) {
        String host = config.getHost();
        int rpcPort = config.getRpcPort();
        int splitSize = config.getSplitSize();
        String keyspace = config.getKeyspace();
        String columnFamily = config.getColumnFamily();
        String partitionerClassName = config.getPartitionerClassName();
        IPartitioner partitioner = (IPartitioner)Utils.newTypeInstance((String)partitionerClassName, IPartitioner.class);
        return new ThriftRangeUtils(partitioner, host, rpcPort, keyspace, columnFamily, splitSize);
    }

    public List<DeepTokenRange> getSplits() {
        List<DeepTokenRange> tokenRanges = this.getRanges();
        ArrayList<DeepTokenRange> splits = new ArrayList<DeepTokenRange>();
        for (DeepTokenRange tokenRange : tokenRanges) {
            List<DeepTokenRange> nodeSplits = this.getSplits(tokenRange);
            splits.addAll(nodeSplits);
        }
        return splits;
    }

    public List<DeepTokenRange> getRanges() {
        try {
            List tokenRanges;
            ThriftClient client = ThriftClient.build(this.host, this.rpcPort);
            try {
                tokenRanges = client.describe_local_ring(this.keyspace);
            }
            catch (TApplicationException e) {
                if (e.getType() == 1) {
                    tokenRanges = client.describe_ring(this.keyspace);
                }
                throw new DeepGenericException("Unknown server error", (Throwable)e);
            }
            client.close();
            ArrayList<DeepTokenRange> deepTokenRanges = new ArrayList<DeepTokenRange>(tokenRanges.size());
            for (TokenRange tokenRange : tokenRanges) {
                Comparable start = this.tokenAsComparable(tokenRange.getStart_token());
                Comparable end = this.tokenAsComparable(tokenRange.getEnd_token());
                deepTokenRanges.add(new DeepTokenRange((Object)start, (Object)end, tokenRange.getEndpoints()));
            }
            return deepTokenRanges;
        }
        catch (TException e) {
            throw new DeepGenericException("No available replicas for get ring token ranges", (Throwable)e);
        }
    }

    public List<DeepTokenRange> getSplits(DeepTokenRange deepTokenRange) {
        String start = this.tokenAsString((Comparable)deepTokenRange.getStartToken());
        String end = this.tokenAsString((Comparable)deepTokenRange.getEndToken());
        List endpoints = deepTokenRange.getReplicas();
        for (String endpoint : endpoints) {
            try {
                ThriftClient client = ThriftClient.build(endpoint, this.rpcPort, this.keyspace);
                List splits = client.describe_splits_ex(this.columnFamily, start, end, this.splitSize);
                client.close();
                return this.deepTokenRanges(splits, endpoints);
            }
            catch (TException e) {
                LOG.warn("Endpoint %s failed while splitting range %s", (Object)endpoint, (Object)deepTokenRange);
            }
        }
        throw new DeepGenericException("No available replicas for splitting range " + deepTokenRange);
    }

    public List<DeepTokenRange> deepTokenRanges(List<CfSplit> splits, List<String> endpoints) {
        ArrayList<DeepTokenRange> result = new ArrayList<DeepTokenRange>();
        for (CfSplit split : splits) {
            Comparable splitEnd;
            Comparable splitStart = this.tokenAsComparable(split.getStart_token());
            if (splitStart.equals(splitEnd = this.tokenAsComparable(split.getEnd_token()))) {
                result.add(new DeepTokenRange((Object)this.minToken, (Object)this.minToken, endpoints));
                continue;
            }
            if (splitStart.compareTo(splitEnd) > 0) {
                result.add(new DeepTokenRange((Object)splitStart, (Object)this.minToken, endpoints));
                result.add(new DeepTokenRange((Object)this.minToken, (Object)splitEnd, endpoints));
                continue;
            }
            result.add(new DeepTokenRange((Object)splitStart, (Object)splitEnd, endpoints));
        }
        return result;
    }

    public Comparable tokenAsComparable(String tokenAsString) {
        Token token = this.tokenFactory.fromString(tokenAsString);
        ByteBuffer bb = this.tokenFactory.toByteArray(token);
        return (Comparable)this.tokenType.compose(bb);
    }

    public String tokenAsString(Comparable tokenAsComparable) {
        ByteBuffer bb = this.tokenType.decompose((Object)tokenAsComparable);
        Token token = this.tokenFactory.fromByteArray(bb);
        return this.tokenFactory.toString(token);
    }
}

