/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.entity;

import com.stratio.deep.entity.Cell;
import com.stratio.deep.exception.DeepGenericException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Cells
implements Iterable<Cell>,
Serializable {
    private static final long serialVersionUID = 3074521612130550380L;
    private List<Cell> cells = new ArrayList<Cell>();

    public Cells() {
    }

    public Cells(Cell ... cells) {
        Collections.addAll(this.cells, cells);
    }

    public boolean add(Cell c) {
        if (c == null) {
            throw new DeepGenericException(new IllegalArgumentException("cell parameter cannot be null"));
        }
        return this.cells.add(c);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cells)) {
            return false;
        }
        Cells o = (Cells)obj;
        if (this.cells.size() != this.size()) {
            return false;
        }
        for (Cell cell : this.cells) {
            Cell otherCell = o.getCellByName(cell.getCellName());
            if (otherCell == null) {
                return false;
            }
            if (otherCell.equals(cell)) continue;
            return false;
        }
        return true;
    }

    public Cell getCellByIdx(int idx) {
        return this.cells.get(idx);
    }

    public Cell getCellByName(String cellName) {
        for (Cell c : this.cells) {
            if (!c.getCellName().equals(cellName)) continue;
            return c;
        }
        return null;
    }

    public Collection<Cell> getCells() {
        return Collections.unmodifiableList(this.cells);
    }

    public Collection<ByteBuffer> getDecomposedCellValues() {
        ArrayList<ByteBuffer> res = new ArrayList<ByteBuffer>();
        for (Cell c : this.cells) {
            res.add(c.getDecomposedCellValue());
        }
        return res;
    }

    public Collection<Object> getCellValues() {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Cell c : this.cells) {
            res.add(c.getCellValue());
        }
        return res;
    }

    public Cells getIndexCells() {
        Cells res = new Cells();
        for (Cell cell : this.cells) {
            if (!cell.isPartitionKey().booleanValue() && !cell.isClusterKey().booleanValue()) continue;
            res.add(cell);
        }
        return res;
    }

    public Cells getValueCells() {
        Cells res = new Cells();
        for (Cell cell : this.cells) {
            if (cell.isPartitionKey().booleanValue() || cell.isClusterKey().booleanValue()) continue;
            res.add(cell);
        }
        return res;
    }

    public int hashCode() {
        return this.cells.hashCode();
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.getCells().iterator();
    }

    public int size() {
        return this.cells.size();
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public String toString() {
        return "Cells{cells=" + this.cells + '}';
    }
}

