/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.utils;

import com.google.common.collect.ImmutableMap;
import com.stratio.deep.annotations.DeepField;
import com.stratio.deep.entity.IDeepType;
import com.stratio.deep.exception.DeepIOException;
import com.stratio.deep.utils.Utils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

public final class AnnotationUtils {
    public static final Map<Class, AbstractType<?>> MAP_JAVA_TYPE_TO_ABSTRACT_TYPE = ImmutableMap.builder().put(String.class, (Object)UTF8Type.instance).put(Integer.class, (Object)Int32Type.instance).put(Boolean.class, (Object)BooleanType.instance).put(Date.class, (Object)TimestampType.instance).put(BigDecimal.class, (Object)DecimalType.instance).put(Long.class, (Object)LongType.instance).put(Double.class, (Object)DoubleType.instance).put(Float.class, (Object)FloatType.instance).put(InetAddress.class, (Object)InetAddressType.instance).put(Inet4Address.class, (Object)InetAddressType.instance).put(Inet6Address.class, (Object)InetAddressType.instance).put(BigInteger.class, (Object)IntegerType.instance).put(UUID.class, (Object)UUIDType.instance).build();
    public static final Map<String, Class> MAP_ABSTRACT_TYPE_CLASSNAME_TO_JAVA_TYPE = ImmutableMap.builder().put((Object)UTF8Type.class.getCanonicalName(), String.class).put((Object)Int32Type.class.getCanonicalName(), Integer.class).put((Object)BooleanType.class.getCanonicalName(), Boolean.class).put((Object)TimestampType.class.getCanonicalName(), Date.class).put((Object)DateType.class.getCanonicalName(), Date.class).put((Object)DecimalType.class.getCanonicalName(), BigDecimal.class).put((Object)LongType.class.getCanonicalName(), Long.class).put((Object)DoubleType.class.getCanonicalName(), Double.class).put((Object)FloatType.class.getCanonicalName(), Float.class).put((Object)InetAddressType.class.getCanonicalName(), InetAddress.class).put((Object)IntegerType.class.getCanonicalName(), BigInteger.class).put((Object)UUIDType.class.getCanonicalName(), UUID.class).put((Object)TimeUUIDType.class.getCanonicalName(), UUID.class).put((Object)SetType.class.getCanonicalName(), Set.class).put((Object)ListType.class.getCanonicalName(), List.class).put((Object)MapType.class.getCanonicalName(), Map.class).build();
    public static final Map<Class<?>, AbstractType<?>> MAP_ABSTRACT_TYPE_CLASS_TO_ABSTRACT_TYPE = ImmutableMap.builder().put(UTF8Type.class, (Object)UTF8Type.instance).put(Int32Type.class, (Object)Int32Type.instance).put(BooleanType.class, (Object)BooleanType.instance).put(TimestampType.class, (Object)TimestampType.instance).put(DateType.class, (Object)DateType.instance).put(DecimalType.class, (Object)DecimalType.instance).put(LongType.class, (Object)LongType.instance).put(DoubleType.class, (Object)DoubleType.instance).put(FloatType.class, (Object)FloatType.instance).put(InetAddressType.class, (Object)InetAddressType.instance).put(IntegerType.class, (Object)IntegerType.instance).put(UUIDType.class, (Object)UUIDType.instance).put(TimeUUIDType.class, (Object)TimeUUIDType.instance).build();

    public static String deepFieldName(Field field) {
        DeepField annotation = field.getAnnotation(DeepField.class);
        if (StringUtils.isNotEmpty((String)annotation.fieldName())) {
            return annotation.fieldName();
        }
        return field.getName();
    }

    public static Field[] filterDeepFields(Class clazz) {
        Field[] fields = Utils.getAllFields(clazz);
        ArrayList<Field> filtered = new ArrayList<Field>();
        for (Field f : fields) {
            if (!f.isAnnotationPresent(DeepField.class)) continue;
            filtered.add(f);
        }
        return filtered.toArray(new Field[filtered.size()]);
    }

    public static Pair<Field[], Field[]> filterKeyFields(Class clazz) {
        Field[] filtered = AnnotationUtils.filterDeepFields(clazz);
        ArrayList<Field> keys = new ArrayList<Field>();
        ArrayList<Field> others = new ArrayList<Field>();
        for (Field field : filtered) {
            if (AnnotationUtils.isKey(field.getAnnotation(DeepField.class))) {
                keys.add(field);
                continue;
            }
            others.add(field);
        }
        return Pair.create((Object)keys.toArray(new Field[keys.size()]), (Object)others.toArray(new Field[others.size()]));
    }

    public static boolean isKey(DeepField field) {
        return field.isPartOfClusterKey() || field.isPartOfPartitionKey();
    }

    public static Serializable getBeanFieldValue(IDeepType entity, Field deepField) {
        try {
            return (Serializable)PropertyUtils.getProperty((Object)entity, (String)deepField.getName());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
            throw new DeepIOException(e1);
        }
    }

    public static Class<?>[] getGenericTypes(Field field) {
        try {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Type[] types = type.getActualTypeArguments();
            Class[] res = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                res[i] = (Class)types[i];
            }
            return res;
        }
        catch (ClassCastException e) {
            return new Class[]{(Class)field.getGenericType()};
        }
    }

    private AnnotationUtils() {
    }
}

