/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.entity;

import com.datastax.driver.core.DataType;
import com.stratio.deep.annotations.DeepField;
import com.stratio.deep.entity.CellValidator;
import com.stratio.deep.entity.IDeepType;
import com.stratio.deep.exception.DeepGenericException;
import com.stratio.deep.exception.DeepInstantiationException;
import com.stratio.deep.utils.AnnotationUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;

public final class Cell
implements Serializable {
    private static final long serialVersionUID = 2298549804049316156L;
    private String cellName;
    private Object cellValue;
    private Boolean isPartitionKey = Boolean.FALSE;
    private Boolean isClusterKey = Boolean.FALSE;
    private CellValidator cellValidator;

    public static Cell create(Cell metadata, Object cellValue) {
        return new Cell(metadata, cellValue);
    }

    public static Cell create(Cell metadata, ByteBuffer cellValue) {
        return new Cell(metadata, cellValue);
    }

    public static Cell create(String cellName, Object cellValue) {
        return Cell.create(cellName, cellValue, Boolean.FALSE, Boolean.FALSE);
    }

    public static Cell create(String cellName) {
        return Cell.create(cellName, (Object)null, Boolean.FALSE, Boolean.FALSE);
    }

    public static Cell create(String cellName, Object cellValue, Boolean isPartitionKey, Boolean isClusterKey) {
        return new Cell(cellName, cellValue, isPartitionKey, isClusterKey);
    }

    public static Cell create(String cellName, DataType cellType, Boolean isPartitionKey, Boolean isClusterKey) {
        return new Cell(cellName, cellType, isPartitionKey, isClusterKey);
    }

    public static <E extends IDeepType> Cell create(E e, Field field) {
        return new Cell(e, field);
    }

    public static CellValidator getValueType(DataType obj) {
        return CellValidator.cellValidator(obj);
    }

    public static CellValidator getValueType(Object obj) {
        return CellValidator.cellValidator(obj);
    }

    private Cell(String cellName, Object cellValue, Boolean isPartitionKey, Boolean isClusterKey) {
        if (cellValue != null && !(cellValue instanceof Serializable)) {
            throw new DeepInstantiationException("provided cell value " + cellValue + " is not serializable");
        }
        this.cellName = cellName;
        this.cellValue = cellValue;
        this.isClusterKey = isClusterKey;
        this.isPartitionKey = isPartitionKey;
        this.cellValidator = Cell.getValueType(cellValue);
    }

    private Cell(String cellName, DataType cellType, Boolean isPartitionKey, Boolean isClusterKey) {
        this.cellName = cellName;
        this.isClusterKey = isClusterKey;
        this.isPartitionKey = isPartitionKey;
        this.cellValidator = Cell.getValueType(cellType);
    }

    private Cell(Cell metadata, ByteBuffer cellValue) {
        this.cellName = metadata.getCellName();
        this.isClusterKey = metadata.isClusterKey;
        this.isPartitionKey = metadata.isPartitionKey;
        this.cellValidator = metadata.cellValidator;
        if (cellValue != null) {
            this.cellValue = metadata.marshaller().compose(cellValue);
        }
    }

    private Cell(Cell metadata, Object cellValue) {
        if (!(cellValue instanceof Serializable)) {
            throw new DeepInstantiationException("provided cell value " + cellValue + " is not serializable");
        }
        this.cellName = metadata.getCellName();
        this.isClusterKey = metadata.isClusterKey;
        this.isPartitionKey = metadata.isPartitionKey;
        this.cellValidator = metadata.cellValidator;
        this.cellValue = cellValue;
    }

    private Cell(IDeepType e, Field field) {
        DeepField annotation = field.getAnnotation(DeepField.class);
        this.cellName = AnnotationUtils.deepFieldName(field);
        this.cellValue = AnnotationUtils.getBeanFieldValue(e, field);
        this.isClusterKey = annotation.isPartOfClusterKey();
        this.isPartitionKey = annotation.isPartOfPartitionKey();
        this.cellValidator = CellValidator.cellValidator(field);
    }

    public CellValidator getCellValidator() {
        return this.cellValidator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.cellName.equals(cell.cellName) && (this.cellValue != null ? this.cellValue.equals(cell.cellValue) : cell.cellValue != null) && this.isClusterKey.equals(cell.isClusterKey) && this.isPartitionKey.equals(cell.isPartitionKey) && this.cellValidator.equals(cell.getCellValidator());
    }

    public Class<?> getValueType() {
        Class valueType = AnnotationUtils.MAP_ABSTRACT_TYPE_CLASSNAME_TO_JAVA_TYPE.get(this.cellValidator.getValidatorClassName());
        if (valueType == null) {
            throw new DeepGenericException("Cannot find value type for marshaller " + this.cellValidator.getValidatorClassName());
        }
        return valueType;
    }

    public String getCellName() {
        return this.cellName;
    }

    public Object getCellValue() {
        return this.cellValue;
    }

    public ByteBuffer getDecomposedCellValue() {
        if (this.cellValue != null) {
            return this.marshaller().decompose(this.cellValue);
        }
        return ByteBuffer.wrap(new byte[0]);
    }

    public int hashCode() {
        int result = this.cellName.hashCode();
        result = 31 * result + (this.cellValue != null ? this.cellValue.hashCode() : 0);
        result = 31 * result + this.isPartitionKey.hashCode();
        result = 31 * result + this.isClusterKey.hashCode();
        result = 31 * result + (this.cellValidator != null ? this.cellValidator.hashCode() : 0);
        return result;
    }

    public Boolean isClusterKey() {
        return this.isClusterKey;
    }

    public Boolean isPartitionKey() {
        return this.isPartitionKey;
    }

    public AbstractType marshaller() {
        if (this.cellValidator != null) {
            return this.cellValidator.getAbstractType();
        }
        return null;
    }

    public String marshallerClassName() {
        if (this.cellValidator != null) {
            return this.cellValidator.getValidatorClassName();
        }
        return null;
    }

    public String toString() {
        return "Cell{cellName='" + this.cellName + '\'' + ", cellValue=" + (this.cellValue != null ? this.cellValue : "") + ", " + "isPartitionKey=" + this.isPartitionKey + ", isClusterKey=" + this.isClusterKey + ", cellValidator='" + this.cellValidator + '\'' + '}';
    }
}

