/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.utils;

import com.stratio.deep.entity.Cell;
import com.stratio.deep.entity.Cells;
import com.stratio.deep.entity.IDeepType;
import com.stratio.deep.exception.DeepGenericException;
import com.stratio.deep.exception.DeepIOException;
import com.stratio.deep.utils.AnnotationUtils;
import com.stratio.deep.utils.Pair;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import scala.Tuple2;

public final class Utils {
    public static Tuple2<Cells, Cells> cellList2tuple(Cells cells) {
        Cells keys = new Cells();
        Cells values = new Cells();
        for (Cell c : cells) {
            if (c.isPartitionKey().booleanValue() || c.isClusterKey().booleanValue()) {
                keys.add(c);
                continue;
            }
            values.add(c);
        }
        return new Tuple2((Object)keys, (Object)values);
    }

    public static <T extends IDeepType> Tuple2<Cells, Cells> deepType2tuple(T e) {
        Pair<Field[], Field[]> fields = AnnotationUtils.filterKeyFields(e.getClass());
        Field[] keyFields = (Field[])fields.left;
        Field[] otherFields = (Field[])fields.right;
        Cells keys = new Cells();
        Cells values = new Cells();
        for (Field keyField : keyFields) {
            keys.add(Cell.create(e, keyField));
        }
        for (Field valueField : otherFields) {
            values.add(Cell.create(e, valueField));
        }
        return new Tuple2((Object)keys, (Object)values);
    }

    public static <T extends IDeepType> T newTypeInstance(Class<T> clazz) {
        try {
            return (T)((IDeepType)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DeepGenericException(e);
        }
    }

    public static <T> T newTypeInstance(String className, Class<T> returnClass) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new DeepGenericException(e);
        }
    }

    public static String quote(String identifier) {
        if (StringUtils.isEmpty((String)identifier)) {
            return identifier;
        }
        String res = identifier.trim();
        if (!res.startsWith("\"")) {
            res = "\"" + res;
        }
        if (!res.endsWith("\"")) {
            res = res + "\"";
        }
        return res;
    }

    public static String singleQuote(String identifier) {
        if (StringUtils.isEmpty((String)identifier)) {
            return identifier;
        }
        String res = identifier.trim();
        if (!res.startsWith("'")) {
            res = "'" + res;
        }
        if (!res.endsWith("'")) {
            res = res + "'";
        }
        return res;
    }

    public static String additionalFilterGenerator(Map<String, Serializable> additionalFilters) {
        if (MapUtils.isEmpty(additionalFilters)) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        for (Map.Entry<String, Serializable> entry : additionalFilters.entrySet()) {
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            if (entry.getValue() instanceof String) {
                value = Utils.singleQuote(value.trim());
            }
            sb.append(" AND ").append(Utils.quote(entry.getKey())).append(" = ").append(value);
        }
        return sb.toString();
    }

    public static String createTableQueryGenerator(Cells keys, Cells values, String outputKeyspace, String outputColumnFamily) {
        if (keys == null || StringUtils.isEmpty((String)outputKeyspace) || StringUtils.isEmpty((String)outputColumnFamily)) {
            throw new DeepGenericException("keys, outputKeyspace and outputColumnFamily cannot be null");
        }
        StringBuilder sb = new StringBuilder("CREATE TABLE ").append(outputKeyspace).append(".").append(outputColumnFamily).append(" (");
        ArrayList<String> partitionKey = new ArrayList<String>();
        ArrayList<String> clusterKey = new ArrayList<String>();
        boolean isFirstField = true;
        for (Cell key : keys) {
            String cellName = Utils.quote(key.getCellName());
            if (!isFirstField) {
                sb.append(", ");
            }
            sb.append(cellName).append(" ").append(key.marshaller().asCQL3Type().toString());
            if (key.isPartitionKey().booleanValue()) {
                partitionKey.add(cellName);
            } else if (key.isClusterKey().booleanValue()) {
                clusterKey.add(cellName);
            }
            isFirstField = false;
        }
        if (values != null) {
            for (Cell key : values) {
                sb.append(", ");
                sb.append(Utils.quote(key.getCellName())).append(" ").append(key.marshaller().asCQL3Type().toString());
            }
        }
        StringBuilder partitionKeyToken = new StringBuilder("(");
        isFirstField = true;
        for (String s : partitionKey) {
            if (!isFirstField) {
                partitionKeyToken.append(", ");
            }
            partitionKeyToken.append(s);
            isFirstField = false;
        }
        partitionKeyToken.append(")");
        StringBuilder clusterKeyToken = new StringBuilder("");
        isFirstField = true;
        for (String s : clusterKey) {
            if (!isFirstField) {
                clusterKeyToken.append(", ");
            }
            clusterKeyToken.append(s);
            isFirstField = false;
        }
        StringBuilder keyPart = new StringBuilder(", PRIMARY KEY ");
        if (!clusterKey.isEmpty()) {
            keyPart.append("(");
        }
        keyPart.append((CharSequence)partitionKeyToken);
        if (!clusterKey.isEmpty()) {
            keyPart.append(", ");
            keyPart.append((CharSequence)clusterKeyToken);
            keyPart.append(")");
        }
        sb.append((CharSequence)keyPart).append(");");
        return sb.toString();
    }

    public static String updateQueryGenerator(Cells keys, Cells values, String outputKeyspace, String outputColumnFamily) {
        StringBuilder sb = new StringBuilder("UPDATE ").append(outputKeyspace).append(".").append(outputColumnFamily).append(" SET ");
        int k = 0;
        StringBuilder keyClause = new StringBuilder(" WHERE ");
        for (Cell cell : keys.getCells()) {
            if (!cell.isPartitionKey().booleanValue() && !cell.isClusterKey().booleanValue()) continue;
            if (k > 0) {
                keyClause.append(" AND ");
            }
            keyClause.append(String.format("%s = ?", Utils.quote(cell.getCellName())));
            ++k;
        }
        k = 0;
        for (Cell cell : values.getCells()) {
            if (k > 0) {
                sb.append(", ");
            }
            sb.append(String.format("%s = ?", Utils.quote(cell.getCellName())));
            ++k;
        }
        sb.append((CharSequence)keyClause).append(";");
        return sb.toString();
    }

    public static String batchQueryGenerator(List<String> statements) {
        StringBuilder sb = new StringBuilder("BEGIN BATCH \n");
        for (String statement : statements) {
            sb.append(statement).append("\n");
        }
        sb.append(" APPLY BATCH;");
        return sb.toString();
    }

    public static Tuple2<String[], Object[]> prepareTuple4CqlDriver(Tuple2<Cells, Cells> tuple) {
        Cell cell;
        Cells keys = (Cells)tuple._1();
        Cells columns = (Cells)tuple._2();
        String[] names = new String[keys.size() + columns.size()];
        Object[] values = new Object[keys.size() + columns.size()];
        for (int k = 0; k < keys.size(); ++k) {
            cell = keys.getCellByIdx(k);
            names[k] = Utils.quote(cell.getCellName());
            values[k] = cell.getCellValue();
        }
        for (int v = keys.size(); v < keys.size() + columns.size(); ++v) {
            cell = columns.getCellByIdx(v - keys.size());
            names[v] = Utils.quote(cell.getCellName());
            values[v] = cell.getCellValue();
        }
        return new Tuple2((Object)names, (Object)values);
    }

    public static Method findSetter(String propertyName, Class entityClass, Class valueType) {
        Method setter;
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            setter = entityClass.getMethod(setterName, valueType);
        }
        catch (NoSuchMethodException e) {
            try {
                setter = entityClass.getMethod(propertyName + "_$eq", valueType);
            }
            catch (NoSuchMethodException e1) {
                throw new DeepIOException(e1);
            }
        }
        return setter;
    }

    public static <T> AbstractType<?> marshallerInstance(T obj) {
        Object abstractType = AnnotationUtils.MAP_JAVA_TYPE_TO_ABSTRACT_TYPE.get(obj.getClass());
        if (obj instanceof UUID) {
            UUID uuid = (UUID)obj;
            abstractType = uuid.version() == 1 ? TimeUUIDType.instance : UUIDType.instance;
        }
        if (abstractType == null) {
            throw new DeepGenericException("parameter class " + obj.getClass().getCanonicalName() + " does not have a" + " Cassandra marshaller");
        }
        return abstractType;
    }

    public static InetAddress inetAddressFromLocation(String location) {
        try {
            return InetAddress.getByName(location);
        }
        catch (UnknownHostException e) {
            throw new DeepIOException(e);
        }
    }

    public static Field[] getAllFields(Class clazz) {
        return Utils.getAllFieldsRec(clazz, new ArrayList<Field>());
    }

    private static Field[] getAllFieldsRec(Class clazz, List<Field> fields) {
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            Utils.getAllFieldsRec(superClazz, fields);
        }
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields.toArray(new Field[fields.size()]);
    }

    private Utils() {
    }
}

