/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.entity;

import com.datastax.driver.core.DataType;
import com.google.common.collect.ImmutableMap;
import com.stratio.deep.annotations.DeepField;
import com.stratio.deep.exception.DeepGenericException;
import com.stratio.deep.exception.DeepInstantiationException;
import com.stratio.deep.utils.AnnotationUtils;
import com.stratio.deep.utils.Utils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.commons.collections.CollectionUtils;

public class CellValidator
implements Serializable {
    private static final String DEFAULT_VALIDATOR_CLASSNAME = "org.apache.cassandra.db.marshal.UTF8Type";
    private static final Map<Class, CQL3Type.Native> MAP_JAVA_TYPE_TO_CQL_TYPE = ImmutableMap.builder().put(String.class, (Object)CQL3Type.Native.TEXT).put(Integer.class, (Object)CQL3Type.Native.INT).put(Boolean.class, (Object)CQL3Type.Native.BOOLEAN).put(Date.class, (Object)CQL3Type.Native.TIMESTAMP).put(BigDecimal.class, (Object)CQL3Type.Native.DECIMAL).put(Long.class, (Object)CQL3Type.Native.BIGINT).put(Double.class, (Object)CQL3Type.Native.DOUBLE).put(Float.class, (Object)CQL3Type.Native.FLOAT).put(InetAddress.class, (Object)CQL3Type.Native.INET).put(Inet4Address.class, (Object)CQL3Type.Native.INET).put(Inet6Address.class, (Object)CQL3Type.Native.INET).put(BigInteger.class, (Object)CQL3Type.Native.VARINT).put(UUID.class, (Object)CQL3Type.Native.UUID).build();
    private static final Map<String, DataType.Name> MAP_JAVA_TYPE_TO_DATA_TYPE_NAME = ImmutableMap.builder().put((Object)UTF8Type.class.getCanonicalName(), (Object)DataType.Name.TEXT).put((Object)Int32Type.class.getCanonicalName(), (Object)DataType.Name.INT).put((Object)BooleanType.class.getCanonicalName(), (Object)DataType.Name.BOOLEAN).put((Object)TimestampType.class.getCanonicalName(), (Object)DataType.Name.TIMESTAMP).put((Object)DateType.class.getCanonicalName(), (Object)DataType.Name.TIMESTAMP).put((Object)DecimalType.class.getCanonicalName(), (Object)DataType.Name.DECIMAL).put((Object)LongType.class.getCanonicalName(), (Object)DataType.Name.BIGINT).put((Object)DoubleType.class.getCanonicalName(), (Object)DataType.Name.DOUBLE).put((Object)FloatType.class.getCanonicalName(), (Object)DataType.Name.FLOAT).put((Object)InetAddressType.class.getCanonicalName(), (Object)DataType.Name.INET).put((Object)IntegerType.class.getCanonicalName(), (Object)DataType.Name.VARINT).put((Object)UUIDType.class.getCanonicalName(), (Object)DataType.Name.UUID).put((Object)TimeUUIDType.class.getCanonicalName(), (Object)DataType.Name.TIMEUUID).put((Object)MapType.class.getCanonicalName(), (Object)DataType.Name.MAP).put((Object)SetType.class.getCanonicalName(), (Object)DataType.Name.SET).put((Object)ListType.class.getCanonicalName(), (Object)DataType.Name.LIST).put((Object)BytesType.class.getCanonicalName(), (Object)DataType.Name.BLOB).build();
    private String validatorClassName = "org.apache.cassandra.db.marshal.UTF8Type";
    private Collection<String> validatorTypes;
    private Kind validatorKind = Kind.NOT_A_COLLECTION;
    private transient AbstractType<?> abstractType;
    private DataType.Name cqlTypeName;

    public static CellValidator cellValidator(Field field) {
        return new CellValidator(field);
    }

    public static CellValidator cellValidator(DataType type) {
        return new CellValidator(type);
    }

    public static <T> CellValidator cellValidator(T obj) {
        if (obj == null) {
            return null;
        }
        Kind kind = Kind.objectToKind(obj);
        AbstractType<?> tAbstractType = Utils.marshallerInstance(obj);
        String validatorClassName = tAbstractType.getClass().getCanonicalName();
        Collection<String> validatorTypes = null;
        DataType.Name cqlTypeName = MAP_JAVA_TYPE_TO_DATA_TYPE_NAME.get(validatorClassName);
        return new CellValidator(validatorClassName, kind, validatorTypes, cqlTypeName);
    }

    private CellValidator(String validatorClassName, Kind validatorKind, Collection<String> validatorTypes, DataType.Name cqlTypeName) {
        this.validatorClassName = validatorClassName != null ? validatorClassName : DEFAULT_VALIDATOR_CLASSNAME;
        this.validatorKind = validatorKind;
        this.validatorTypes = validatorTypes;
        this.cqlTypeName = cqlTypeName;
    }

    private static String getCollectionInnerType(Class<?> type) {
        CQL3Type.Native nativeType = MAP_JAVA_TYPE_TO_CQL_TYPE.get(type);
        return nativeType.name().toLowerCase();
    }

    private CellValidator(Field field) {
        Class<?>[] types = AnnotationUtils.getGenericTypes(field);
        DeepField annotation = field.getAnnotation(DeepField.class);
        Class<? extends AbstractType> clazz = annotation.validationClass();
        this.validatorClassName = annotation.validationClass().getCanonicalName();
        this.validatorKind = Kind.validatorClassToKind(clazz);
        this.cqlTypeName = MAP_JAVA_TYPE_TO_DATA_TYPE_NAME.get(this.validatorClassName);
        switch (this.validatorKind) {
            case SET: 
            case LIST: {
                this.validatorTypes = Arrays.asList(CellValidator.getCollectionInnerType(types[0]));
                break;
            }
            case MAP: {
                this.validatorTypes = Arrays.asList(CellValidator.getCollectionInnerType(types[0]), CellValidator.getCollectionInnerType(types[1]));
                break;
            }
        }
    }

    private CellValidator(DataType type) {
        if (type == null) {
            throw new DeepInstantiationException("input DataType cannot be null");
        }
        this.cqlTypeName = type.getName();
        if (!type.isCollection()) {
            this.validatorClassName = AnnotationUtils.MAP_JAVA_TYPE_TO_ABSTRACT_TYPE.get(type.asJavaClass()).getClass().getName();
        } else {
            this.validatorTypes = new ArrayList<String>();
            for (DataType dataType : type.getTypeArguments()) {
                this.validatorTypes.add(dataType.toString());
            }
            switch (type.getName()) {
                case SET: {
                    this.validatorKind = Kind.SET;
                    this.validatorClassName = SetType.class.getName();
                    break;
                }
                case LIST: {
                    this.validatorKind = Kind.LIST;
                    this.validatorClassName = ListType.class.getName();
                    break;
                }
                case MAP: {
                    this.validatorKind = Kind.MAP;
                    this.validatorClassName = MapType.class.getName();
                    break;
                }
                default: {
                    throw new DeepGenericException("Cannot determine collection type for " + type.getName());
                }
            }
            this.validatorTypes = Collections.unmodifiableCollection(this.validatorTypes);
        }
    }

    public AbstractType<?> getAbstractType() {
        if (this.abstractType != null) {
            return this.abstractType;
        }
        try {
            if (this.validatorKind == Kind.NOT_A_COLLECTION) {
                this.abstractType = AnnotationUtils.MAP_ABSTRACT_TYPE_CLASS_TO_ABSTRACT_TYPE.get(Class.forName(this.validatorClassName));
            } else {
                Iterator<String> types = this.validatorTypes.iterator();
                switch (this.validatorKind) {
                    case SET: {
                        CQL3Type.Native cql3Type = CQL3Type.Native.valueOf((String)types.next().toUpperCase());
                        this.abstractType = SetType.getInstance((AbstractType)cql3Type.getType());
                        break;
                    }
                    case LIST: {
                        CQL3Type.Native cql3Type = CQL3Type.Native.valueOf((String)types.next().toUpperCase());
                        this.abstractType = ListType.getInstance((AbstractType)cql3Type.getType());
                        break;
                    }
                    case MAP: {
                        CQL3Type.Native cql3Type = CQL3Type.Native.valueOf((String)types.next().toUpperCase());
                        CQL3Type.Native cql3Type2 = CQL3Type.Native.valueOf((String)types.next().toUpperCase());
                        this.abstractType = MapType.getInstance((AbstractType)cql3Type.getType(), (AbstractType)cql3Type2.getType());
                        break;
                    }
                    default: {
                        throw new DeepGenericException("Cannot determine collection kind for " + (Object)((Object)this.validatorKind));
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeepGenericException(e);
        }
        return this.abstractType;
    }

    public String getValidatorClassName() {
        return this.validatorClassName;
    }

    public Collection<String> getValidatorTypes() {
        return this.validatorTypes;
    }

    public Kind validatorKind() {
        return this.validatorKind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellValidator that = (CellValidator)o;
        if (this.validatorKind != that.validatorKind) {
            return false;
        }
        if (!this.validatorClassName.equals(that.validatorClassName)) {
            return false;
        }
        return this.validatorKind == Kind.NOT_A_COLLECTION || CollectionUtils.isEqualCollection(this.validatorTypes, that.validatorTypes);
    }

    public int hashCode() {
        int result = this.validatorClassName.hashCode();
        result = 31 * result + (this.validatorTypes != null ? this.validatorTypes.hashCode() : 0);
        result = 31 * result + this.validatorKind.hashCode();
        return result;
    }

    public String toString() {
        return "CellValidator{validatorClassName='" + this.validatorClassName + '\'' + ", validatorTypes=" + (this.validatorTypes != null ? this.validatorTypes : "") + ", validatorKind=" + (Object)((Object)this.validatorKind) + ", abstractType=" + this.abstractType + '}';
    }

    public DataType.Name getCqlTypeName() {
        return this.cqlTypeName;
    }

    public static enum Kind {
        MAP,
        SET,
        LIST,
        NOT_A_COLLECTION;


        public static Kind validatorClassToKind(Class<? extends AbstractType> type) {
            if (type == null) {
                return NOT_A_COLLECTION;
            }
            if (type.equals(SetType.class)) {
                return SET;
            }
            if (type.equals(ListType.class)) {
                return LIST;
            }
            if (type.equals(MapType.class)) {
                return MAP;
            }
            return NOT_A_COLLECTION;
        }

        public static <T> Kind objectToKind(T object) {
            if (object == null) {
                return NOT_A_COLLECTION;
            }
            Kind res = Set.class.isAssignableFrom(object.getClass()) ? SET : (List.class.isAssignableFrom(object.getClass()) ? LIST : (Map.class.isAssignableFrom(object.getClass()) ? MAP : NOT_A_COLLECTION));
            return res;
        }
    }
}

