/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.utils;

import com.stratio.deep.entity.IDeepType;
import com.stratio.deep.utils.AnnotationUtils;
import com.stratio.deep.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class UtilMongoDB {
    public static <T> T getObjectFromBson(Class<T> classEntity, BSONObject bsonObject) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        T t = classEntity.newInstance();
        Field[] fields = AnnotationUtils.filterDeepFields(classEntity);
        int count = fields.length;
        Object insert = null;
        for (int i = 0; i < count; ++i) {
            Method method = Utils.findSetter(fields[i].getName(), classEntity, fields[i].getType());
            Class<?> classField = fields[i].getType();
            Object currentBson = bsonObject.get(AnnotationUtils.deepFieldName(fields[i]));
            if (currentBson == null) continue;
            if (Iterable.class.isAssignableFrom(classField)) {
                Method methodGetter = Utils.findGetter(fields[i].getName(), classEntity);
                Type type = fields[i].getGenericType();
                insert = UtilMongoDB.subDocumentListCase(type, (List)bsonObject.get(AnnotationUtils.deepFieldName(fields[i])));
            } else {
                insert = IDeepType.class.isAssignableFrom(classField) ? UtilMongoDB.getObjectFromBson(classField, (BSONObject)bsonObject.get(AnnotationUtils.deepFieldName(fields[i]))) : currentBson;
            }
            method.invoke(t, insert);
        }
        return t;
    }

    private static <T> Object subDocumentListCase(Type type, List<T> bsonOject) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ParameterizedType listType = (ParameterizedType)type;
        Class listClass = (Class)listType.getActualTypeArguments()[0];
        ArrayList<T> list = new ArrayList<T>();
        for (T t : bsonOject) {
            list.add(UtilMongoDB.getObjectFromBson(listClass, (BSONObject)t));
        }
        return list;
    }

    public static <T extends IDeepType> BSONObject getBsonFromObject(T t) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Field[] fields = AnnotationUtils.filterDeepFields(t.getClass());
        int count = fields.length;
        BasicBSONObject bson = new BasicBSONObject();
        for (int i = 0; i < count; ++i) {
            Method method = Utils.findGetter(fields[i].getName(), t.getClass());
            bson.put(AnnotationUtils.deepFieldName(fields[i]), method.invoke(t, new Object[0]));
        }
        return bson;
    }

    public static <T extends IDeepType> Object getId(T t) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Field[] fields = AnnotationUtils.filterDeepFields(t.getClass());
        int count = fields.length;
        for (int i = 0; i < count; ++i) {
            if (!AnnotationUtils.deepFieldName(fields[i]).equals("_id")) continue;
            return Utils.findGetter(fields[i].getName(), t.getClass()).invoke(t, new Object[0]);
        }
        return null;
    }
}

