/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.config;

import com.stratio.deep.commons.config.BaseConfig;
import com.stratio.deep.commons.config.ExtractorConfig;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.filter.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DeepJobConfig<T, S>
extends BaseConfig<T>
implements Serializable {
    protected String username;
    protected String password;
    protected String nameSpace;
    protected String catalog;
    protected String table;
    protected int port;
    protected List<String> host = new ArrayList<String>();
    protected String[] inputColumns;
    protected Filter[] filters;

    public DeepJobConfig() {
        super(Cells.class);
    }

    public DeepJobConfig(Class<T> t) {
        super(t);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNameSpace() {
        if (this.nameSpace == null) {
            this.nameSpace = this.catalog + "." + this.table;
        }
        return this.nameSpace;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getTable() {
        return this.table;
    }

    public String[] getInputColumns() {
        return this.inputColumns;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getHostList() {
        return this.host;
    }

    public String getHost() {
        return !this.host.isEmpty() ? this.host.get(0) : null;
    }

    public S initialize(ExtractorConfig extractorConfig) {
        Map<String, Serializable> values = extractorConfig.getValues();
        if (values.get("user") != null) {
            this.username(extractorConfig.getString("user"));
        }
        if (values.get("password") != null) {
            this.password(extractorConfig.getString("password"));
        }
        if (values.get("host") != null) {
            this.host(extractorConfig.getStringArray("host"));
        }
        if (values.get("Port") != null) {
            this.port(extractorConfig.getInteger("Port"));
        }
        if (values.get("table") != null) {
            this.table(extractorConfig.getString("table"));
        }
        if (values.get("inputColumns") != null) {
            this.inputColumns(extractorConfig.getStringArray("inputColumns"));
        }
        if (values.get("catalog") != null) {
            this.catalog(extractorConfig.getString("catalog"));
        }
        if (values.get("filterQuery") != null) {
            this.filters(extractorConfig.getFilterArray("filterQuery"));
        }
        return (S)this;
    }

    public S host(String hostName) {
        this.host.add(hostName);
        return (S)this;
    }

    public S host(String ... hostNames) {
        for (String hostName : hostNames) {
            this.host.add(hostName);
        }
        return (S)this;
    }

    public S host(List<String> hostNames) {
        this.host.addAll(hostNames);
        return (S)this;
    }

    public S password(String password) {
        this.password = password;
        return (S)this;
    }

    public S table(String table) {
        this.table = table;
        return (S)this;
    }

    public S catalog(String catalog) {
        this.catalog = catalog;
        return (S)this;
    }

    public S username(String username) {
        this.username = username;
        return (S)this;
    }

    public S port(Integer port) {
        this.port = port;
        return (S)this;
    }

    public S inputColumns(String[] inputColumns) {
        this.inputColumns = inputColumns;
        return (S)this;
    }

    public S filters(Filter[] filters) {
        this.filters = filters;
        return (S)this;
    }

    public S initialize() {
        return (S)this;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("DeepJobConfig{");
        sb.append("username='").append(this.username).append('\'');
        sb.append(", password='").append(this.password).append('\'');
        sb.append(", nameSpace='").append(this.nameSpace).append('\'');
        sb.append(", catalog='").append(this.catalog).append('\'');
        sb.append(", table='").append(this.table).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", host=").append(this.host);
        sb.append(", inputColumns=").append(this.inputColumns == null ? "null" : Arrays.asList(this.inputColumns).toString());
        sb.append(", filters=").append(this.filters == null ? "null" : Arrays.asList(this.filters).toString());
        sb.append('}');
        sb.append(super.toString());
        return sb.toString();
    }
}

