/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Cell
implements Serializable {
    private static final long serialVersionUID = 2298549804049316156L;
    protected String cellName;
    protected Object cellValue;
    protected Boolean isKey = Boolean.FALSE;
    protected Boolean isClusterKey = Boolean.FALSE;

    protected Cell() {
    }

    protected Cell(String cellName, Object cellValue) {
        this.cellName = cellName;
        this.cellValue = cellValue;
    }

    protected Cell(String cellName, Object cellValue, Boolean isKey) {
        this.cellName = cellName;
        this.cellValue = cellValue;
        this.isKey = isKey;
    }

    protected Cell(String cellName, Object cellValue, Boolean isKey, Boolean isClusterKey) {
        this.cellName = cellName;
        this.cellValue = cellValue;
        this.isKey = isKey;
        this.isClusterKey = isClusterKey;
    }

    public static Cell create(String cellName, Object cellValue) {
        return new Cell(cellName, cellValue);
    }

    public static Cell create(String cellName, Object cellValue, Boolean isKey) {
        return new Cell(cellName, cellValue, isKey);
    }

    public static Cell create(String cellName, Object cellValue, Boolean isKey, Boolean isClusterKey) {
        return new Cell(cellName, cellValue, isKey, isClusterKey);
    }

    public String getCellName() {
        return this.cellName;
    }

    public Object getCellValue() {
        return this.cellValue;
    }

    public String getName() {
        return this.cellName;
    }

    public Object getValue() {
        return this.cellValue;
    }

    public <T> T getValue(Class<T> clazz) {
        if (this.cellValue == null) {
            return null;
        }
        return (T)this.cellValue;
    }

    public String getString() {
        return this.getValue(String.class);
    }

    public Boolean getBoolean() {
        return this.getValue(Boolean.class);
    }

    public Date getDate() {
        return this.getValue(Date.class);
    }

    public UUID getUUID() {
        return this.getValue(UUID.class);
    }

    public Short getShort() {
        return this.getValue(Short.class);
    }

    public Byte getByte() {
        return this.getValue(Byte.class);
    }

    public Byte[] getBytes() {
        return this.getValue(Byte[].class);
    }

    public Character getCharacter() {
        return this.getValue(Character.class);
    }

    public Integer getInteger() {
        return this.getValue(Integer.class);
    }

    public Long getLong() {
        return this.getValue(Long.class);
    }

    public BigInteger getBigInteger() {
        return this.getValue(BigInteger.class);
    }

    public Float getFloat() {
        return this.getValue(Float.class);
    }

    public Double getDouble() {
        return this.getValue(Double.class);
    }

    public BigDecimal getBigDecimal() {
        return this.getValue(BigDecimal.class);
    }

    public URL getURL() {
        return this.getValue(URL.class);
    }

    public InetAddress getInetAddress() {
        return this.getValue(InetAddress.class);
    }

    public <T> List<T> getList(Class<T> clazz) {
        if (this.cellValue == null) {
            return null;
        }
        return (List)this.cellValue;
    }

    public <T> Set<T> getSet(Class<T> clazz) {
        if (this.cellValue == null) {
            return null;
        }
        return (Set)this.cellValue;
    }

    public <K, V> Map<K, V> getMap(Class<K> keysClass, Class<V> valuesClass) {
        if (this.cellValue == null) {
            return null;
        }
        return (Map)this.cellValue;
    }

    public Boolean isKey() {
        return this.isKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.cellName.equals(cell.cellName) && this.cellValue.equals(cell.cellValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cellName == null ? 0 : this.cellName.hashCode());
        result = 31 * result + (this.cellValue == null ? 0 : this.cellValue.hashCode());
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Cell{");
        sb.append("cellName='").append(this.cellName).append('\'');
        sb.append(", cellValue=").append(this.cellValue);
        sb.append(", isKey=").append(this.isKey);
        sb.append(", isClusterKey=").append(this.isClusterKey);
        sb.append('}');
        return sb.toString();
    }

    public Boolean getIsKey() {
        return this.isKey;
    }

    public void setIsKey(Boolean isKey) {
        this.isKey = isKey;
    }

    public Boolean isClusterKey() {
        return this.isClusterKey;
    }

    public void setIsClusterKey(Boolean isClusterKey) {
        this.isClusterKey = isClusterKey;
    }
}

