/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.impl;

import com.stratio.deep.commons.exception.DeepIOException;
import com.stratio.deep.commons.exception.DeepInstantiationException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Comparator;

public class DeepPartitionLocationComparator
implements Comparator<String> {
    private final InetAddress hostname;

    public DeepPartitionLocationComparator() {
        try {
            this.hostname = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new DeepInstantiationException(e);
        }
    }

    public DeepPartitionLocationComparator(String hostname) {
        try {
            this.hostname = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            throw new DeepInstantiationException(e);
        }
    }

    @Override
    public int compare(String loc1, String loc2) {
        int result = 0;
        try {
            InetAddress addr1 = InetAddress.getByName(loc1);
            InetAddress addr2 = InetAddress.getByName(loc2);
            if (addr1 == addr2) {
                result = 0;
            } else if (addr1.isLoopbackAddress()) {
                result = -1;
            } else if (addr2.isLoopbackAddress()) {
                result = 1;
            } else if (addr1.getHostAddress().equals(this.hostname.getHostAddress())) {
                result = -1;
            } else if (addr2.getHostAddress().equals(this.hostname.getHostAddress())) {
                result = 1;
            }
        }
        catch (UnknownHostException e) {
            throw new DeepIOException(e);
        }
        return result;
    }

    public InetAddress getHostname() {
        return this.hostname;
    }
}

